/*
 * Decompiled with CFR 0.152.
 */
package net.blugrid.core.dao;

import com.google.gson.GsonBuilder;
import java.util.UUID;
import javax.sql.DataSource;
import net.blugrid.core.dao.MediaObjectDAO;
import net.blugrid.core.dao.WebPageDAO;
import net.blugrid.core.model.JsonData;
import net.blugrid.core.model.MediaObject;
import net.blugrid.core.model.MediaObjectResponse;
import net.blugrid.core.model.Token;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class MediaObjectDAOImpl
implements MediaObjectDAO {
    private static final Logger logger = Logger.getLogger(MediaObjectDAOImpl.class);
    @Autowired
    @Qualifier(value="dbDataSource")
    private DataSource dataSource;
    @Autowired
    private WebPageDAO WebPagedao;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public String getAll(Token token) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_mediaobject(   :token::t_pgpmessage,   NULL::t_uuid ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public String getByUUID(Token token, UUID uuid) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_mediaobject(   :token::t_pgpmessage,   :inmediaobjectuuid::t_uuid ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        parameters.addValue("inmediaobjectuuid", (Object)uuid.toString());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public MediaObjectResponse post(Token Token2, MediaObject mediaObject) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json FROM proc_post_mediaobject(   :insessiontoken::t_pgpmessage,  :inmediaobjectuuid::t_uuid,  :inmediaobjecttype::t_mediaobjecttype,  :incontenturl::t_urladdress,  :inembedcode::t_text,  :inreferenceid::t_code,  :instatus::t_status  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("insessiontoken", (Object)Token2.getid_token());
        parameters.addValue("inmediaobjectuuid", (Object)mediaObject.getMediaobjectuuid());
        parameters.addValue("inmediaobjecttype", (Object)mediaObject.getMediaobjecttype());
        parameters.addValue("incontenturl", (Object)mediaObject.getContenturl());
        parameters.addValue("inembedcode", (Object)mediaObject.getEmbedcode());
        parameters.addValue("inreferenceid", (Object)mediaObject.getReferenceid());
        parameters.addValue("instatus", (Object)mediaObject.getStatus());
        JsonData jsondata = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        MediaObjectResponse response = (MediaObjectResponse)new GsonBuilder().create().fromJson(jsondata.getJson(), MediaObjectResponse.class);
        return response;
    }
}

