/*
 * Decompiled with CFR 0.152.
 */
package net.blugrid.core.dao;

import java.util.ArrayList;
import javax.sql.DataSource;
import net.blugrid.core.dao.TimeGroupDAO;
import net.blugrid.core.model.JsonData;
import net.blugrid.core.model.TimeGroup;
import net.blugrid.core.model.TimeGroupResponse;
import net.blugrid.core.model.TimePeriod;
import net.blugrid.core.model.TimePeriodResponse;
import net.blugrid.core.model.Token;
import net.blugrid.core.utils.PostgresqlJson;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class TimeGroupDAOImpl
implements TimeGroupDAO {
    private static final Logger logger = Logger.getLogger(TimeGroupDAOImpl.class);
    @Autowired
    @Qualifier(value="dbDataSource")
    private DataSource dataSource;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public TimeGroupResponse post(Token token, TimeGroup timegroup) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json FROM proc_post_timegroup(   :insessiontoken::t_pgpmessage,   :intimegroupuuid::t_uuid,   :indescription::t_name,   :instatus::t_status ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("insessiontoken", (Object)token.getid_token());
        parameters.addValue("intimegroupuuid", (Object)timegroup.getTimegroupuuid());
        parameters.addValue("indescription", (Object)timegroup.getDescription());
        parameters.addValue("instatus", (Object)timegroup.getStatus());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        TimeGroupResponse response = PostgresqlJson.jsonToTimeGroupResponse((String)json.getJson());
        if (timegroup.getTimeperiods() != null) {
            ArrayList<TimePeriod> tpList = new ArrayList<TimePeriod>();
            for (int i = 0; i < timegroup.getTimeperiods().size(); ++i) {
                ((TimePeriod)timegroup.getTimeperiods().get(i)).setTimegroupuuid(response.getTimegroup().getTimegroupuuid());
                TimePeriodResponse tmr = this.postTimePeriod(token, (TimePeriod)timegroup.getTimeperiods().get(i));
                tpList.add(tmr.getTimeperiod());
            }
            response.getTimegroup().setTimeperiods(tpList);
        }
        return response;
    }

    private TimePeriodResponse postTimePeriod(Token token, TimePeriod timeperiod) {
        TimePeriodResponse response = new TimePeriodResponse();
        response.setTimeperiod(timeperiod);
        if (timeperiod.getStarttime() != null && timeperiod.getEndtime() != null) {
            NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
            String sql = "SELECT outjson AS json FROM proc_post_timeperiod(   :insessiontoken::t_pgpmessage,   :intimeperioduuid::t_uuid,   :inweekday::t_weekday,   :instarttime::t_time,   :inendtime::t_time,   :intimegroupuuid::t_uuid,   :instatus::t_status ) ";
            MapSqlParameterSource parameters = new MapSqlParameterSource();
            parameters.addValue("insessiontoken", (Object)token.getid_token());
            parameters.addValue("intimeperioduuid", (Object)timeperiod.getTimeperioduuid());
            parameters.addValue("inweekday", (Object)timeperiod.getWeekday());
            parameters.addValue("inweekday", (Object)timeperiod.getWeekday());
            parameters.addValue("instarttime", (Object)timeperiod.getStarttime());
            parameters.addValue("inendtime", (Object)timeperiod.getEndtime());
            parameters.addValue("intimegroupuuid", (Object)timeperiod.getTimegroupuuid());
            parameters.addValue("instatus", (Object)timeperiod.getStatus());
            JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
            response = PostgresqlJson.jsonToTimePeriodResponse((String)json.getJson());
        }
        return response;
    }
}

