/*
 * Decompiled with CFR 0.152.
 */
package net.blugrid.core.dao;

import java.util.ArrayList;
import java.util.UUID;
import javax.sql.DataSource;
import net.blugrid.core.dao.GeoLocationDAO;
import net.blugrid.core.model.Country;
import net.blugrid.core.model.GeoLocationQueryParameters;
import net.blugrid.core.model.JsonData;
import net.blugrid.core.model.State;
import net.blugrid.core.model.Token;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class GeoLocationDAOImpl
implements GeoLocationDAO {
    @Autowired
    @Qualifier(value="dbDataSource")
    private DataSource dataSource;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public String getAllCountry(Token token) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_country(    :token::t_pgpmessage  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public String getByQueryParams(Token token, GeoLocationQueryParameters queryparams) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_geolocation_cities(    :token::t_pgpmessage,    :incountrynames::TEXT[],    :instatenames::TEXT[]  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        if (queryparams.getCountrys().size() > 0) {
            ArrayList<String> clist = new ArrayList<String>();
            for (int j = 0; j < queryparams.getCountrys().size(); ++j) {
                if (((Country)queryparams.getCountrys().get(j)).getCountryname() == null) continue;
                String cname = ((Country)queryparams.getCountrys().get(j)).getCountryname();
                clist.add(cname);
            }
            String str = ((Object)clist).toString();
            str = str.replace("[", "{");
            str = str.replace("]", "}");
            parameters.addValue("incountrynames", (Object)str);
        } else {
            parameters.addValue("incountrynames", null);
        }
        if (queryparams.getStates().size() > 0) {
            ArrayList<String> slist = new ArrayList<String>();
            for (int j = 0; j < queryparams.getStates().size(); ++j) {
                String sname = ((State)queryparams.getStates().get(j)).getName().toString();
                slist.add(sname);
            }
            String str2 = ((Object)slist).toString();
            str2 = str2.replace("[", "{");
            str2 = str2.replace("]", "}");
            parameters.addValue("instatenames", (Object)str2);
        } else {
            parameters.addValue("instatenames", null);
        }
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public String getByUUID(Token token, UUID uuid) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_geolocation(    :token::t_pgpmessage,    :ingeolocationuuid::t_uuid  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        parameters.addValue("ingeolocationuuid", (Object)uuid.toString());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }
}

