/*
 * Decompiled with CFR 0.152.
 */
package net.blugrid.core.dao;

import java.util.ArrayList;
import javax.sql.DataSource;
import net.blugrid.core.dao.AdvertisementDAO;
import net.blugrid.core.dao.AdvertisingSetDAO;
import net.blugrid.core.dao.AudienceDAO;
import net.blugrid.core.dao.ScheduleDAO;
import net.blugrid.core.dao.TargetLocationDAO;
import net.blugrid.core.model.Advertisement;
import net.blugrid.core.model.AdvertisementResponse;
import net.blugrid.core.model.AdvertisingSet;
import net.blugrid.core.model.AdvertisingSetResponse;
import net.blugrid.core.model.Audience;
import net.blugrid.core.model.AudienceResponse;
import net.blugrid.core.model.JsonData;
import net.blugrid.core.model.Schedule;
import net.blugrid.core.model.ScheduleResponse;
import net.blugrid.core.model.TargetLocation;
import net.blugrid.core.model.TargetLocationResponse;
import net.blugrid.core.model.Token;
import net.blugrid.core.utils.PostgresqlJson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class AdvertisingSetDAOImpl
implements AdvertisingSetDAO {
    @Autowired
    @Qualifier(value="dbDataSource")
    private DataSource dataSource;
    @Autowired
    private AudienceDAO Audiencedao;
    @Autowired
    private TargetLocationDAO TargetLocationdao;
    @Autowired
    private ScheduleDAO Scheduledao;
    @Autowired
    private AdvertisementDAO Advertisementdao;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public AdvertisingSetResponse post(Token token, AdvertisingSet advertisingset) {
        AdvertisingSetResponse response = new AdvertisingSetResponse();
        if (advertisingset.getAdvertisingcampaignuuid() == null) {
            response.setStatus("ERROR");
            response.setSource("AdvertisingSetDAOImpl");
            response.setMessage("No Advertising Campaign UUID.");
        } else {
            NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
            String sql = "SELECT outjson AS json from proc_post_advertisingset(    :token::t_pgpmessage,    :inadvertisingsetuuid::t_uuid,   :inadvertisingsetname::t_name,    :inadvertisementtype::t_advertisementtype,    :inadvertisingcampaignuuid::t_uuid,    :inbudgetuuid::t_uuid,   :inwebpageuuid::t_uuid,   :inscheduleuuid::t_uuid,   :inaudienceuuid::t_uuid,    :intargetlocationuuid::t_uuid,    :instatus::t_status  ) ";
            MapSqlParameterSource parameters = new MapSqlParameterSource();
            parameters.addValue("token", (Object)token.getid_token());
            if (advertisingset.getAdvertisingcampaignuuid() != null) {
                parameters.addValue("inadvertisingsetuuid", (Object)advertisingset.getAdvertisingsetuuid());
            } else {
                parameters.addValue("inadvertisingsetuuid", null);
            }
            parameters.addValue("instatus", (Object)advertisingset.getStatus());
            parameters.addValue("inadvertisingsetname", (Object)advertisingset.getAdvertisingsetname());
            parameters.addValue("inadvertisementtype", (Object)advertisingset.getAdvertisementtype());
            parameters.addValue("inadvertisingcampaignuuid", (Object)advertisingset.getAdvertisingcampaignuuid());
            parameters.addValue("inbudgetuuid", null);
            parameters.addValue("inwebpageuuid", (Object)advertisingset.getWebpage().getWebpageuuid());
            ScheduleResponse schedresponse = this.Scheduledao.post(token, advertisingset.getSchedule());
            if (schedresponse.getStatus().equalsIgnoreCase("OK")) {
                Schedule schedule = schedresponse.getSchedule();
                parameters.addValue("inscheduleuuid", (Object)schedule.getScheduleuuid());
                AudienceResponse audienceresponse = new AudienceResponse();
                Audience audience = new Audience();
                if (advertisingset.getAudience().getAudienceselectors() == null | advertisingset.getAudience().getAudienceselectors().size() == 0) {
                    audienceresponse.setStatus("OK");
                    parameters.addValue("inaudienceuuid", null);
                } else {
                    audienceresponse = this.Audiencedao.post(token, advertisingset.getAudience());
                    if (audienceresponse.getStatus().equalsIgnoreCase("OK")) {
                        audience = audienceresponse.getAudience();
                        parameters.addValue("inaudienceuuid", (Object)audience.getAudienceuuid());
                    }
                }
                TargetLocationResponse targetlocationresponse = new TargetLocationResponse();
                TargetLocation targetlocation = new TargetLocation();
                if (advertisingset.getTargetlocation().getTargetlocationselectors() == null) {
                    targetlocationresponse.setStatus("OK");
                    parameters.addValue("intargetlocationuuid", null);
                } else {
                    targetlocationresponse = this.TargetLocationdao.post(token, advertisingset.getTargetlocation());
                    if (targetlocationresponse.getStatus().equalsIgnoreCase("OK")) {
                        targetlocation = targetlocationresponse.getTargetlocation();
                        parameters.addValue("intargetlocationuuid", (Object)targetlocation.getTargetlocationuuid());
                    }
                }
                JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
                response = PostgresqlJson.jsonToAdvertisingSetResponse((JsonData)json);
                if (response.getStatus().equalsIgnoreCase("OK")) {
                    ArrayList<Advertisement> advertisements = new ArrayList<Advertisement>();
                    for (int i = 0; i < advertisingset.getAdvertisements().size(); ++i) {
                        AdvertisementResponse advertisementresponse = this.Advertisementdao.post(token, (Advertisement)advertisingset.getAdvertisements().get(i));
                        if (!advertisementresponse.getStatus().equalsIgnoreCase("OK")) continue;
                        advertisements.add(advertisementresponse.getAdvertisement());
                    }
                    response.getAdvertisingset().setAdvertisements(advertisements);
                }
            }
        }
        return response;
    }
}

