/*
 * Decompiled with CFR 0.152.
 */
package net.blugrid.service;

import com.redfin.sitemapgenerator.ChangeFreq;
import com.redfin.sitemapgenerator.ISitemapUrl;
import com.redfin.sitemapgenerator.SitemapGeneratorBuilder;
import com.redfin.sitemapgenerator.WebSitemapGenerator;
import com.redfin.sitemapgenerator.WebSitemapUrl;
import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.blugrid.core.model.Token;
import net.blugrid.core.model.WebPage;
import net.blugrid.core.model.Website;
import net.blugrid.service.S3ServiceConnector;
import net.blugrid.service.WebSitemapService;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WebSitemapServiceImpl
implements WebSitemapService {
    private static final Logger logger = Logger.getLogger(WebSitemapServiceImpl.class);
    @Autowired
    private S3ServiceConnector S3Serviceconnector;

    @Override
    public void updateWebSitemap(Token token, Website website) {
        File file = this.createWebSitemap(website);
        String bucketname = website.getDomainname();
        this.S3Serviceconnector.uploadFile(token, bucketname, file, "sitemap.xml");
    }

    private File createWebSitemap(Website website) {
        String domain = "https://" + website.getDomainname();
        List webpages = website.getWebpages();
        File targetFolder = new File("/data/temp/");
        List sitemapfiles = new ArrayList();
        int nrOfURLs = 0;
        try {
            WebSitemapGenerator wsg = (WebSitemapGenerator)((SitemapGeneratorBuilder)((SitemapGeneratorBuilder)WebSitemapGenerator.builder((String)domain, (File)targetFolder).fileNamePrefix(website.getDomainname() + "_sitemap.xml")).gzip(false)).build();
            logger.info((Object)"WebSitemapGenerator created.");
            for (WebPage webpage : webpages) {
                if (webpage.getUrl() == null || !webpage.getStatus().equalsIgnoreCase("Active") || webpage.getLft() == null || webpage.getLft() == 1) continue;
                String url = domain + "/#!" + webpage.getUrl();
                WebSitemapUrl wsmUrl = ((WebSitemapUrl.Options)((WebSitemapUrl.Options)((WebSitemapUrl.Options)new WebSitemapUrl.Options(url).lastMod(new Date())).priority(Double.valueOf(0.9))).changeFreq(ChangeFreq.DAILY)).build();
                wsg.addUrl((ISitemapUrl)wsmUrl);
                ++nrOfURLs;
                logger.info((Object)("url added to sitemap: " + url));
            }
            if (nrOfURLs <= 50000) {
                sitemapfiles = wsg.write();
            } else {
                wsg.write();
                wsg.writeSitemapsWithIndex();
            }
        }
        catch (MalformedURLException ex) {
            logger.error((Object)ex);
        }
        return (File)sitemapfiles.get(0);
    }
}

