/*
 * Decompiled with CFR 0.152.
 */
package net.blugrid.core.dao;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.sql.DataSource;
import net.blugrid.core.dao.WebContentDAO;
import net.blugrid.core.dao.WebPageDAO;
import net.blugrid.core.model.JsonData;
import net.blugrid.core.model.ObjectResponse;
import net.blugrid.core.model.Response;
import net.blugrid.core.model.Token;
import net.blugrid.core.model.WebContent;
import net.blugrid.core.model.WebPage;
import net.blugrid.core.model.WebPageState;
import net.blugrid.core.utils.PostgresqlJson;
import net.blugrid.service.SeoService;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class WebPageDAOImpl
implements WebPageDAO {
    private static final Logger logger = Logger.getLogger(WebPageDAOImpl.class);
    @Autowired
    @Qualifier(value="dbDataSource")
    private DataSource dataSource;
    @Autowired
    private WebContentDAO Webcontentdao;
    @Autowired
    private SeoService SeoService;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public String getAll(Token token) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_webpage(    :token::t_pgpmessage,    NULL::t_uuid,    NULL::t_uuid  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public String getByUUID(Token token, UUID uuid) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_webpage(    :token::t_pgpmessage,    NULL::t_uuid,    :inuuid::t_uuid  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        parameters.addValue("inuuid", (Object)uuid.toString());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public String getBySate(Token token, WebPageState state) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_webpage_by_state(    :token::t_pgpmessage,    :instate::t_name  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        parameters.addValue("instate", (Object)state.getStatename());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public ObjectResponse<WebPage> postByUUID(Token token, WebPage webpage) {
        WebPage newWebpage = new WebPage();
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String websql = "SELECT outjson as json  FROM proc_post_webpage (    :insessiontoken::t_pgpmessage,    :inwebpageuuid::t_uuid,    :inwebpagename::t_descriptionshort,    :inwebpagetitle::t_text,    :inwebpagedescription::t_text,    :inurl::t_descriptionshort,    :inmenuitem::t_flag,    :inlinkname::t_descriptionshort,    :inicon::t_name,    :insequence::t_identity,    :inrequireslogin::t_flag,    :inlayoutoptions::t_json,    :inparentuuid::t_uuid,    :inimageuuid::t_uuid,    :initemuuid::t_uuid,    :inblogarticleuuid::t_uuid,    :ineventuuid::t_uuid,    :indeviceuuid::t_uuid,    :inwebpagetemplateuuid::t_uuid,    :inhashtaglist::text[],    :instatus::t_status ) ";
        MapSqlParameterSource eparameters = new MapSqlParameterSource();
        eparameters.addValue("insessiontoken", (Object)token.getid_token());
        eparameters.addValue("inwebpageuuid", (Object)webpage.getWebpageuuid());
        eparameters.addValue("inwebpagename", (Object)webpage.getWebpagename());
        eparameters.addValue("inwebpagetitle", (Object)webpage.getWebpagetitle());
        eparameters.addValue("inwebpagedescription", (Object)webpage.getWebpagedescription());
        eparameters.addValue("inurl", (Object)webpage.getUrl());
        eparameters.addValue("inurlparams", (Object)webpage.getUrl());
        eparameters.addValue("inmenuitem", (Object)webpage.getMenuitem());
        eparameters.addValue("inlinkname", (Object)webpage.getLinkname());
        eparameters.addValue("inicon", (Object)webpage.getIcon());
        eparameters.addValue("insequence", (Object)webpage.getSequence());
        eparameters.addValue("inrequireslogin", (Object)webpage.getRequireslogin());
        eparameters.addValue("inlayoutoptions", webpage.getLayoutoptions());
        eparameters.addValue("inparentuuid", (Object)webpage.getParentuuid());
        eparameters.addValue("inblogarticleuuid", (Object)webpage.getBlogarticleuuid());
        eparameters.addValue("ineventuuid", (Object)webpage.getEventuuid());
        eparameters.addValue("initemuuid", (Object)webpage.getItemuuid());
        if (webpage.getImage() != null) {
            eparameters.addValue("inimageuuid", (Object)webpage.getImage().getImageuuid());
        } else {
            eparameters.addValue("inimageuuid", null);
        }
        if (webpage.getWebpagetemplate() != null) {
            eparameters.addValue("inwebpagetemplateuuid", (Object)webpage.getWebpagetemplate().getWebpagetemplateuuid());
        }
        eparameters.addValue("indeviceuuid", (Object)webpage.getDeviceuuid());
        eparameters.addValue("inhashtaglist", (Object)webpage.getHashtagStringList());
        eparameters.addValue("instatus", (Object)webpage.getStatus());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(websql, (SqlParameterSource)eparameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        Type type = new TypeToken<ObjectResponse<WebPage>>(){}.getType();
        ObjectResponse response = (ObjectResponse)new Gson().fromJson(json.getJson(), type);
        if (response != null && response.getData() != null) {
            newWebpage = (WebPage)response.getData();
            if (!webpage.getWebcontent().isEmpty()) {
                UUID webpageuuid = newWebpage.getWebpageuuid();
                ArrayList<WebContent> webcontentlist = new ArrayList<WebContent>();
                for (int i = 0; i < webpage.getWebcontent().size(); ++i) {
                    if (((WebContent)webpage.getWebcontent().get(i)).getStatus() == null) {
                        ((WebContent)webpage.getWebcontent().get(i)).setStatus("Active");
                    }
                    ((WebContent)webpage.getWebcontent().get(i)).setWebpageuuid(webpageuuid);
                    WebContent webcontent = this.Webcontentdao.post(token, (WebContent)webpage.getWebcontent().get(i));
                    webcontentlist.add(webcontent);
                }
                newWebpage.setWebcontent(webcontentlist);
            }
            if (webpage.getWebpageuuid() != null) {
                this.SeoService.saveStaticWebPage(token, newWebpage);
            }
        }
        return response;
    }

    @Override
    public Response postTrackingData(Token token, UUID webpageuuid) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String websql = "SELECT outstatus as status  FROM proc_post_webpage_click_stream_click (    :insessiontoken::t_pgpmessage,    :inwebpageuuid::t_uuid ) ";
        MapSqlParameterSource eparameters = new MapSqlParameterSource();
        eparameters.addValue("insessiontoken", (Object)token.getid_token());
        eparameters.addValue("inwebpageuuid", (Object)webpageuuid.toString());
        Response response = (Response)namedParameterJdbcTemplate.queryForObject(websql, (SqlParameterSource)eparameters, (RowMapper)BeanPropertyRowMapper.newInstance(Response.class));
        logger.info((Object)("postTrackingData for webpage uuid: " + webpageuuid.toString()));
        return response;
    }

    @Override
    public List<WebPage> getMainMenu(Token token) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson from proc_view_website_menu(    :token::t_pgpmessage,    NULL::t_uuid  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        List jsondata = namedParameterJdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new RowMapper<JsonData>(){

            public JsonData mapRow(ResultSet rs, int rowNum) throws SQLException {
                JsonData json = new JsonData();
                json.setJson(rs.getString("outjson"));
                return json;
            }
        });
        List response = PostgresqlJson.jsonListWebPageList((List)jsondata);
        return response;
    }
}

