/*
 * Decompiled with CFR 0.152.
 */
package net.blugrid.core.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import net.blugrid.core.dao.LookupTypeDAO;
import net.blugrid.core.model.JsonData;
import net.blugrid.core.model.LookupTypes;
import net.blugrid.core.model.Token;
import net.blugrid.core.utils.PostgresqlJson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class LookupTypeDAOImpl
implements LookupTypeDAO {
    @Autowired
    @Qualifier(value="dbDataSource")
    private DataSource dataSource;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public LookupTypes getAll(Token token) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson from proc_view_lookup_types(:token::t_pgpmessage) ";
        MapSqlParameterSource namedParameters = new MapSqlParameterSource("token", (Object)token.getid_token());
        List jsondata = namedParameterJdbcTemplate.query(sql, (SqlParameterSource)namedParameters, (RowMapper)new RowMapper<JsonData>(){

            public JsonData mapRow(ResultSet rs, int rowNum) throws SQLException {
                JsonData json = new JsonData();
                json.setJson(rs.getString("outjson"));
                return json;
            }
        });
        LookupTypes response = PostgresqlJson.jsonToLookupTypes((JsonData)((JsonData)jsondata.get(0)));
        return response;
    }
}

