/*
 * Decompiled with CFR 0.152.
 */
package net.blugrid.core.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import net.blugrid.core.dao.ImageDAO;
import net.blugrid.core.model.Image;
import net.blugrid.core.model.ImageGallery;
import net.blugrid.core.model.JsonData;
import net.blugrid.core.model.LogoVariation;
import net.blugrid.core.model.Response;
import net.blugrid.core.model.Token;
import net.blugrid.core.utils.PostgresqlJson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class ImageDAOImpl
implements ImageDAO {
    @Autowired
    @Qualifier(value="dbDataSource")
    private DataSource dataSource;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public List<Image> getAll(Token token) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson from proc_view_image(   :token::t_pgpmessage,   NULL::t_uuid ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        List jsondata = namedParameterJdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new RowMapper<JsonData>(){

            public JsonData mapRow(ResultSet rs, int rowNum) throws SQLException {
                JsonData json = new JsonData();
                json.setJson(rs.getString("outjson"));
                return json;
            }
        });
        List response = PostgresqlJson.jsonListImageList((List)jsondata);
        return response;
    }

    @Override
    public Image postImage(Token Token2, ImageGallery gallery, Image image) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outimageuuid AS imageuuid FROM proc_post_image (    :sessiontoken::t_pgpmessage,   :imageuuid::t_uuid,   :name::t_name,   :url::t_urladdress,   :filename::t_descriptionshort,   NULL::t_uuid,    :imagegalleryuuid::t_uuid ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("sessiontoken", (Object)Token2.getid_token());
        parameters.addValue("imageuuid", (Object)image.getImageuuid());
        parameters.addValue("name", (Object)image.getName());
        parameters.addValue("url", (Object)image.getUrl());
        parameters.addValue("filename", (Object)image.getFilename());
        parameters.addValue("imagegalleryuuid", (Object)gallery.getImagegalleryuuid());
        Image imguuid = (Image)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(Image.class));
        image.setImageuuid(imguuid.getImageuuid());
        return image;
    }

    @Override
    public Response deleteByUUID(Token token, Image image) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outstatus as status,    outsource as source,    outmessage as message FROM proc_del_image(   :sessiontoken::t_pgpmessage,   :imageuuid::t_uuid ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("sessiontoken", (Object)token.getid_token());
        parameters.addValue("imageuuid", (Object)image.getImageuuid());
        Response response = (Response)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(Response.class));
        return response;
    }

    @Override
    public String postLogoVariation(Token Token2, LogoVariation logovar) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json FROM proc_post_logovariation (   :insessiontoken::t_pgpmessage,  :inimageuuid::t_uuid,  :inname::t_name,  :inurl::t_urladdress,  :infilename::t_descriptionshort,  :inlogouuid::t_uuid,  :inimageformat::t_imageformat,   :inimagesizetype::t_imagesizetype,  :inimagebackgroundtype::t_imagebackgroundtype,  :instatus::t_status )";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("insessiontoken", (Object)Token2.getid_token());
        parameters.addValue("inimageuuid", (Object)logovar.getImage().getImageuuid());
        parameters.addValue("inname", (Object)logovar.getImage().getName());
        parameters.addValue("inurl", (Object)logovar.getImage().getUrl());
        parameters.addValue("infilename", (Object)logovar.getImage().getFilename());
        parameters.addValue("inlogouuid", (Object)logovar.getLogouuid().toString());
        parameters.addValue("inimageformat", (Object)logovar.getImageformat());
        parameters.addValue("inimagesizetype", (Object)logovar.getImagesizetype());
        parameters.addValue("inimagebackgroundtype", (Object)logovar.getImagebackgroundtype());
        parameters.addValue("instatus", (Object)logovar.getStatus());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }
}

