/*
 * Decompiled with CFR 0.152.
 */
package net.blugrid.core.dao;

import java.util.UUID;
import javax.sql.DataSource;
import net.blugrid.core.dao.EventDAO;
import net.blugrid.core.dao.WebPageDAO;
import net.blugrid.core.model.Address;
import net.blugrid.core.model.CustomerAccount;
import net.blugrid.core.model.CustomerAccountResponse;
import net.blugrid.core.model.Event;
import net.blugrid.core.model.JsonData;
import net.blugrid.core.model.ObjectResponse;
import net.blugrid.core.model.Token;
import net.blugrid.core.model.WebPage;
import net.blugrid.core.utils.PostgresqlJson;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class EventDAOImpl
implements EventDAO {
    private static final Logger logger = Logger.getLogger(EventDAOImpl.class);
    @Autowired
    @Qualifier(value="dbDataSource")
    private DataSource dataSource;
    @Autowired
    private WebPageDAO WebPagedao;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public Event post(Token Token2, Event event) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outeventuuid AS eventuuid FROM proc_post_event (  :sessiontoken::t_pgpmessage,  :eventuuid::t_uuid,  :eventname::t_name,  :eventdescription::t_descriptionnarrative,  :inavailabletickets::t_quantitytransactioncount,  :inmaxtickets::t_quantitytransactioncount,  :inticketscommited::t_quantitytransactioncount,  :ineventterms::t_descriptionnarrative,  :insignupmessageuuid::t_uuid,  :instarttimestamp::t_timestamp,  :inendtimestamp::t_timestamp,  :instatus::t_status ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        String emptystr = "";
        parameters.addValue("sessiontoken", (Object)Token2.getid_token());
        parameters.addValue("eventuuid", (Object)event.getEventuuid());
        parameters.addValue("eventname", (Object)event.getEventname());
        parameters.addValue("eventdescription", (Object)event.getEventdescription());
        parameters.addValue("inavailabletickets", (Object)event.getAvailabletickets());
        parameters.addValue("inmaxtickets", (Object)event.getMaxtickets());
        parameters.addValue("inticketscommited", (Object)event.getTicketscommited());
        parameters.addValue("ineventterms", (Object)event.getEventterms());
        if (event.getSignupemail() != null) {
            parameters.addValue("insignupmessageuuid", (Object)event.getSignupemail().getMessageuuid());
        } else {
            parameters.addValue("insignupmessageuuid", null);
        }
        if (event.getStarttimestamp() != null) {
            parameters.addValue("instarttimestamp", (Object)event.getStarttimestamp());
        } else {
            parameters.addValue("instarttimestamp", null);
        }
        if (event.getEndtimestamp() != null) {
            parameters.addValue("inendtimestamp", (Object)event.getEndtimestamp());
        } else {
            parameters.addValue("inendtimestamp", null);
        }
        parameters.addValue("instatus", (Object)event.getStatus());
        Event eventnew = (Event)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(Event.class));
        event.setEventuuid(eventnew.getEventuuid());
        if (event.getAddress() != null) {
            String addrsql = "SELECT outaddressuuid as addressuuid FROM proc_post_event_address (  :sessiontoken::t_pgpmessage,  :ineventuuid::t_uuid,  :contactpurposetypecode::t_contactpurposetype, :addressuuid::t_uuid, :addressline1::t_Address, :addressline2::t_Address, :addressline3::t_Address, :incityname::t_City, :instatename::t_name, :postalcode::t_PostalCode,  :incountrycode2::t_code2,  :instatecode::t_code,  :status::t_status ) ";
            MapSqlParameterSource aparameters = new MapSqlParameterSource();
            aparameters.addValue("sessiontoken", (Object)Token2.getid_token());
            aparameters.addValue("ineventuuid", (Object)event.getEventuuid());
            aparameters.addValue("addressuuid", (Object)event.getAddress().getAddressuuid());
            aparameters.addValue("contactpurposetypecode", (Object)event.getAddress().getContactpurposetypecode());
            aparameters.addValue("addressline1", (Object)event.getAddress().getAddressline1());
            aparameters.addValue("addressline2", (Object)event.getAddress().getAddressline2());
            aparameters.addValue("addressline3", (Object)event.getAddress().getAddressline3());
            aparameters.addValue("incityname", (Object)event.getAddress().getCityname());
            aparameters.addValue("instatename", (Object)event.getAddress().getStatename());
            aparameters.addValue("postalcode", (Object)event.getAddress().getPostalcode());
            aparameters.addValue("incountrycode2", (Object)event.getAddress().getCountry().getCountrycode2());
            aparameters.addValue("instatecode", (Object)event.getAddress().getState().getCode());
            aparameters.addValue("status", (Object)event.getAddress().getStatus());
            Address addr = (Address)namedParameterJdbcTemplate.queryForObject(addrsql, (SqlParameterSource)aparameters, (RowMapper)BeanPropertyRowMapper.newInstance(Address.class));
            event.getAddress().setAddressuuid(addr.getAddressuuid());
        }
        if (event.getWebpages() != null) {
            for (int i = 0; i < event.getWebpages().size(); ++i) {
                ObjectResponse<WebPage> webpageResponse = this.WebPagedao.postByUUID(Token2, (WebPage)event.getWebpages().get(i));
                if (!webpageResponse.getStatus().equalsIgnoreCase("OK") || webpageResponse.getData() == null) continue;
                event.getWebpages().set(i, webpageResponse.getData());
                logger.info((Object)("posted webpage uuid: " + ((WebPage)webpageResponse.getData()).getWebpageuuid().toString()));
            }
        }
        return event;
    }

    @Override
    public CustomerAccountResponse postCustomerEventRegistration(Token token, CustomerAccount customeraccount) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json FROM proc_post_event_customeraccount (  :sessiontoken::t_pgpmessage,  :inpartyuuid::t_uuid,  :incustomeraccountuuid::t_uuid,  :incustomeraccounttype::t_customeraccounttype,  :incustomeraccountcode::t_codemetadata,  :ineffectivedate::t_timestamp,  :inexpirationdate::t_timestamp,  :incustomeraccountstatus::t_customeraccountstatus,  :eventuuid::t_uuid,   :ineventadmissionclassuuid::t_uuid ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        String emptystr = "";
        parameters.addValue("sessiontoken", (Object)token.getid_token());
        if (customeraccount.getPartyuuid() != null) {
            parameters.addValue("inpartyuuid", (Object)customeraccount.getPartyuuid());
        } else {
            parameters.addValue("inpartyuuid", null);
        }
        if (customeraccount.getEventuuid() != null) {
            parameters.addValue("incustomeraccountuuid", (Object)customeraccount.getCustomeraccountuuid());
        } else {
            parameters.addValue("incustomeraccountuuid", null);
        }
        parameters.addValue("incustomeraccounttype", (Object)customeraccount.getCustomeraccounttype());
        parameters.addValue("incustomeraccountcode", (Object)customeraccount.getCustomeraccountcode());
        parameters.addValue("ineffectivedate", (Object)customeraccount.getExpirationdate());
        parameters.addValue("inexpirationdate", (Object)customeraccount.getExpirationdate());
        parameters.addValue("incustomeraccountstatus", (Object)customeraccount.getCustomeraccountuuid());
        if (customeraccount.getEventuuid() != null) {
            parameters.addValue("eventuuid", (Object)customeraccount.getEventuuid());
        } else {
            parameters.addValue("eventuuid", null);
        }
        if (customeraccount.getEventadmissionclassuuid() != null) {
            parameters.addValue("ineventadmissionclassuuid", (Object)customeraccount.getEventadmissionclassuuid());
        } else {
            parameters.addValue("ineventadmissionclassuuid", null);
        }
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        CustomerAccountResponse response = PostgresqlJson.jsonToCustomerAccountResponse((String)json.getJson());
        return response;
    }

    @Override
    public String getAll(Token token) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_event(:token::t_pgpmessage,   NULL::t_uuid ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        return json.getJson();
    }

    @Override
    public String getByUUIDString(Token token, UUID uuid) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_event(   :token::t_pgpmessage,   :eventuuid::t_uuid ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        parameters.addValue("eventuuid", (Object)uuid);
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public Event getByUUID(Token token, UUID uuid) {
        String json = this.getByUUIDString(token, uuid);
        Event event = PostgresqlJson.jsonToEvent((String)json);
        return event;
    }

    @Override
    public String getCustomerRegistrations(Token token, UUID uuid) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json FROM proc_view_event_customer_registrations(   :token::t_pgpmessage,   :eventuuid::t_uuid ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        parameters.addValue("eventuuid", (Object)uuid);
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }
}

