/*
 * Decompiled with CFR 0.152.
 */
package net.blugrid.core.dao;

import java.util.UUID;
import javax.sql.DataSource;
import net.blugrid.core.dao.DocumentDAO;
import net.blugrid.core.model.Document;
import net.blugrid.core.model.JsonData;
import net.blugrid.core.model.Response;
import net.blugrid.core.model.Token;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class DocumentDAOImpl
implements DocumentDAO {
    @Autowired
    @Qualifier(value="dbDataSource")
    private DataSource dataSource;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public String getAll(Token token) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_document(   :token::t_pgpmessage,   NULL::t_uuid ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public String getByUUID(Token token, UUID uuid) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_document(   :token::t_pgpmessage,   :indocumentfolderuuid::t_uuid ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        parameters.addValue("indocumentfolderuuid", (Object)uuid.toString());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public Document post(Token Token2, Document document) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outdocumentuuid AS documentuuid FROM proc_post_document(   :insessiontoken::t_pgpmessage,  :indocumentuuid::t_uuid,  :indocumenttype::t_documenttype,   :indocumentname::t_descriptionshort,   :indocumentdescription::t_text,   :inhtml::t_text,   :instatus::t_status,   :indocumentfolderuuid::t_uuid,   :inowneruuid::t_uuid  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("insessiontoken", (Object)Token2.getid_token());
        parameters.addValue("indocumentuuid", (Object)document.getDocumentuuid());
        parameters.addValue("indocumenttype", (Object)document.getDocumenttype());
        parameters.addValue("indocumentname", (Object)document.getDocumentname());
        parameters.addValue("indocumentdescription", (Object)document.getDocumentdescription());
        parameters.addValue("inhtml", (Object)document.getHtml());
        parameters.addValue("instatus", (Object)document.getStatus());
        parameters.addValue("indocumentfolderuuid", (Object)document.getFolder().getDocumentfolderuuid());
        parameters.addValue("inowneruuid", (Object)document.getOwner().getPartyuuid());
        Document uuid = (Document)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(Document.class));
        document.setDocumentuuid(uuid.getDocumentuuid());
        return document;
    }

    @Override
    public Response deleteByUUID(Token token, Document document) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outstatus as status,    outsource as source,    outmessage as message FROM proc_del_document(   :sessiontoken::t_pgpmessage,   :documentuuid::t_uuid ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("sessiontoken", (Object)token.getid_token());
        parameters.addValue("documentuuid", (Object)document.getDocumentuuid());
        Response response = (Response)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(Response.class));
        return response;
    }
}

