/*
 * Decompiled with CFR 0.152.
 */
package net.bitnine.agensgraph.util;

import java.util.Map;
import net.bitnine.agensgraph.util.Jsonb;
import net.bitnine.agensgraph.util.JsonbArrayBuilder;
import net.bitnine.agensgraph.util.JsonbObjectBuilder;

public class JsonbUtil {
    private JsonbUtil() {
    }

    public static Jsonb create(String value) {
        return new Jsonb(value);
    }

    public static Jsonb create(int value) {
        return JsonbUtil.create((long)value);
    }

    public static Jsonb create(long value) {
        return new Jsonb(value);
    }

    public static Jsonb create(double value) {
        return new Jsonb(value);
    }

    public static Jsonb create(boolean value) {
        return new Jsonb(value);
    }

    public static Jsonb createNull() {
        return new Jsonb(null);
    }

    public static JsonbArrayBuilder createArrayBuilder() {
        return new JsonbArrayBuilder();
    }

    public static Jsonb createArray() {
        return JsonbUtil.createArrayBuilder().build();
    }

    public static Jsonb createArray(String ... values) {
        JsonbArrayBuilder builder = JsonbUtil.createArrayBuilder();
        for (String value : values) {
            builder.add(value);
        }
        return builder.build();
    }

    public static Jsonb createArray(Object ... values) {
        JsonbArrayBuilder builder = JsonbUtil.createArrayBuilder();
        for (Object value : values) {
            builder.add(value);
        }
        return builder.build();
    }

    public static Jsonb createArray(Iterable<?> values) {
        JsonbArrayBuilder builder = JsonbUtil.createArrayBuilder();
        for (Object value : values) {
            builder.add(value);
        }
        return builder.build();
    }

    public static JsonbObjectBuilder createObjectBuilder() {
        return new JsonbObjectBuilder();
    }

    public static Jsonb createObject() {
        return JsonbUtil.createObjectBuilder().build();
    }

    public static Jsonb createObject(Map<String, ?> map) {
        JsonbObjectBuilder builder = JsonbUtil.createObjectBuilder();
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            builder.add(entry.getKey(), entry.getValue());
        }
        return builder.build();
    }

    static Object filterValueType(Object value) throws IllegalArgumentException {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return value;
        }
        if (value instanceof Integer) {
            return ((Integer)value).longValue();
        }
        if (value instanceof Long) {
            return value;
        }
        if (value instanceof Double) {
            return value;
        }
        if (value instanceof Boolean) {
            return value;
        }
        if (value instanceof Jsonb) {
            return ((Jsonb)value).getJsonValue();
        }
        if (value instanceof Map) {
            return JsonbUtil.createObject((Map)value);
        }
        if (value instanceof Iterable) {
            return JsonbUtil.createArray((Iterable)value);
        }
        throw new IllegalArgumentException("Invalid json value type");
    }
}

