/*
 * Decompiled with CFR 0.152.
 */
package net.bitnine.agensgraph.util;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.bitnine.agensgraph.deps.org.json.simple.JSONArray;
import net.bitnine.agensgraph.deps.org.json.simple.JSONObject;
import net.bitnine.agensgraph.deps.org.json.simple.JSONValue;
import net.bitnine.agensgraph.deps.org.postgresql.util.PGobject;
import net.bitnine.agensgraph.deps.org.postgresql.util.PSQLException;
import net.bitnine.agensgraph.deps.org.postgresql.util.PSQLState;
import net.bitnine.agensgraph.util.JsonbObject;

public class Jsonb
extends PGobject
implements JsonbObject,
Serializable,
Cloneable {
    private Object jsonValue = null;

    public Jsonb() {
        this.setType("jsonb");
    }

    Jsonb(Object obj) {
        this();
        this.jsonValue = obj;
    }

    @Override
    public void setValue(String value) throws SQLException {
        Object obj;
        try {
            obj = JSONValue.parseWithException(value);
        }
        catch (Exception e) {
            throw new PSQLException("Parsing jsonb failed", PSQLState.DATA_ERROR, (Throwable)e);
        }
        super.setValue(value);
        this.jsonValue = obj;
    }

    @Override
    public String getValue() {
        if (this.value == null) {
            this.value = JSONValue.toJSONString(this.jsonValue);
        }
        return this.value;
    }

    public Object getJsonValue() {
        return this.jsonValue;
    }

    private String getString(Object obj) {
        if (obj instanceof String) {
            return (String)obj;
        }
        throw new UnsupportedOperationException("Not a string: " + obj);
    }

    private boolean isInteger(long l) {
        return l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE;
    }

    private int getInt(Object obj) {
        if (obj instanceof Long) {
            long l = (Long)obj;
            if (this.isInteger(l)) {
                return (int)l;
            }
            throw new IllegalArgumentException("Bad value for type int: " + l);
        }
        if (obj instanceof String) {
            String s = this.getString(obj);
            if (this.isLong(s = s.trim())) {
                return this.getInt(Long.parseLong(s));
            }
        }
        throw new UnsupportedOperationException("Not an int: " + obj);
    }

    private boolean isLong(String s) {
        try {
            Long.parseLong(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private long getLong(Object obj) {
        if (obj instanceof Long) {
            return (Long)obj;
        }
        if (obj instanceof String) {
            String s = this.getString(obj);
            if (this.isLong(s = s.trim())) {
                return this.getLong(Long.parseLong(s));
            }
        }
        throw new UnsupportedOperationException("Not a long: " + obj);
    }

    private boolean isDouble(String s) {
        try {
            Double.parseDouble(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private double getDouble(Object obj) {
        if (obj instanceof Double) {
            return (Double)obj;
        }
        if (obj instanceof String) {
            String s = this.getString(obj);
            if (this.isDouble(s = s.trim())) {
                return this.getDouble(Double.parseDouble(s));
            }
        }
        throw new UnsupportedOperationException("Not a double: " + obj);
    }

    private boolean getBoolean(Object obj) {
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof String) {
            return ((String)obj).length() > 0;
        }
        if (obj instanceof Long) {
            return (Long)obj != 0L;
        }
        if (obj instanceof Double) {
            return (Double)obj != 0.0;
        }
        if (obj instanceof JSONArray) {
            return ((JSONArray)obj).size() > 0;
        }
        if (obj instanceof JSONObject) {
            return ((JSONObject)obj).size() > 0;
        }
        return false;
    }

    private Jsonb getArray(Object obj) {
        if (obj instanceof JSONArray) {
            return new Jsonb(obj);
        }
        throw new UnsupportedOperationException("Not an array: " + obj);
    }

    private Jsonb getObject(Object obj) {
        if (obj instanceof JSONObject) {
            return new Jsonb(obj);
        }
        throw new UnsupportedOperationException("Not an object: " + obj);
    }

    public String tryGetString() {
        if (this.jsonValue instanceof String) {
            return (String)this.jsonValue;
        }
        return null;
    }

    public String getString() {
        return this.getString(this.jsonValue);
    }

    public int getInt() {
        return this.getInt(this.jsonValue);
    }

    public long getLong() {
        return this.getLong(this.jsonValue);
    }

    public double getDouble() {
        return this.getDouble(this.jsonValue);
    }

    public boolean getBoolean() {
        return this.getBoolean(this.jsonValue);
    }

    @Override
    public boolean isNull() {
        return this.jsonValue == null;
    }

    public Jsonb getArray() {
        return this.getArray(this.jsonValue);
    }

    public Jsonb getObject() {
        return this.getObject(this.jsonValue);
    }

    public String getString(int index) {
        if (!(this.jsonValue instanceof JSONArray)) {
            throw new UnsupportedOperationException("Not an array: " + this.jsonValue);
        }
        JSONArray a = (JSONArray)this.jsonValue;
        return this.getString(a.get(index));
    }

    public int getInt(int index) {
        if (!(this.jsonValue instanceof JSONArray)) {
            throw new UnsupportedOperationException("Not an array: " + this.jsonValue);
        }
        JSONArray a = (JSONArray)this.jsonValue;
        return this.getInt(a.get(index));
    }

    public long getLong(int index) {
        if (!(this.jsonValue instanceof JSONArray)) {
            throw new UnsupportedOperationException("Not an array: " + this.jsonValue);
        }
        JSONArray a = (JSONArray)this.jsonValue;
        return this.getLong(a.get(index));
    }

    public double getDouble(int index) {
        if (!(this.jsonValue instanceof JSONArray)) {
            throw new UnsupportedOperationException("Not an array: " + this.jsonValue);
        }
        JSONArray a = (JSONArray)this.jsonValue;
        return this.getDouble(a.get(index));
    }

    public boolean getBoolean(int index) {
        if (!(this.jsonValue instanceof JSONArray)) {
            throw new UnsupportedOperationException("Not an array: " + this.jsonValue);
        }
        JSONArray a = (JSONArray)this.jsonValue;
        return this.getBoolean(a.get(index));
    }

    public Jsonb getArray(int index) {
        if (!(this.jsonValue instanceof JSONArray)) {
            throw new UnsupportedOperationException("Not an array: " + this.jsonValue);
        }
        JSONArray a = (JSONArray)this.jsonValue;
        return this.getArray(a.get(index));
    }

    public Jsonb getObject(int index) {
        if (!(this.jsonValue instanceof JSONArray)) {
            throw new UnsupportedOperationException("Not an array: " + this.jsonValue);
        }
        JSONArray a = (JSONArray)this.jsonValue;
        return this.getObject(a.get(index));
    }

    public boolean isNull(int index) {
        if (!(this.jsonValue instanceof JSONArray)) {
            throw new UnsupportedOperationException("Not an array: " + this.jsonValue);
        }
        JSONArray a = (JSONArray)this.jsonValue;
        return a.get(index) == null;
    }

    @Override
    public Iterable<String> getKeys() {
        if (!(this.jsonValue instanceof JSONObject)) {
            throw new UnsupportedOperationException("Not an object: " + this.jsonValue);
        }
        JSONObject o = (JSONObject)this.jsonValue;
        ArrayList<String> keys = new ArrayList<String>(o.size());
        for (Object k : o.keySet()) {
            keys.add((String)k);
        }
        return keys;
    }

    @Override
    public boolean containsKey(String key) {
        if (!(this.jsonValue instanceof JSONObject)) {
            throw new UnsupportedOperationException("Not an object: " + this.jsonValue);
        }
        JSONObject o = (JSONObject)this.jsonValue;
        return o.containsKey(key);
    }

    @Override
    public String getString(String key) {
        if (!(this.jsonValue instanceof JSONObject)) {
            throw new UnsupportedOperationException("Not an object: " + this.jsonValue);
        }
        JSONObject o = (JSONObject)this.jsonValue;
        return this.getString(o.get(key));
    }

    @Override
    public String getString(String key, String defaultValue) {
        return this.containsKey(key) ? this.getString(key) : defaultValue;
    }

    private Object getIntObject(String key) {
        if (!(this.jsonValue instanceof JSONObject)) {
            throw new UnsupportedOperationException("Not an object: " + this.jsonValue);
        }
        JSONObject o = (JSONObject)this.jsonValue;
        return o.get(key);
    }

    @Override
    public int getInt(String key) {
        return this.getInt(this.getIntObject(key));
    }

    @Override
    public int getInt(String key, int defaultValue) {
        return this.containsKey(key) ? this.getInt(key) : defaultValue;
    }

    @Override
    public long getLong(String key) {
        if (!(this.jsonValue instanceof JSONObject)) {
            throw new UnsupportedOperationException("Not an object: " + this.jsonValue);
        }
        JSONObject o = (JSONObject)this.jsonValue;
        return this.getLong(o.get(key));
    }

    @Override
    public long getLong(String key, long defaultValue) {
        return this.containsKey(key) ? this.getLong(key) : defaultValue;
    }

    @Override
    public double getDouble(String key) {
        if (!(this.jsonValue instanceof JSONObject)) {
            throw new UnsupportedOperationException("Not an object: " + this.jsonValue);
        }
        JSONObject o = (JSONObject)this.jsonValue;
        return this.getDouble(o.get(key));
    }

    @Override
    public double getDouble(String key, double defaultValue) {
        return this.containsKey(key) ? this.getDouble(key) : defaultValue;
    }

    @Override
    public boolean getBoolean(String key) {
        if (!(this.jsonValue instanceof JSONObject)) {
            throw new UnsupportedOperationException("Not an object: " + this.jsonValue);
        }
        JSONObject o = (JSONObject)this.jsonValue;
        return this.getBoolean(o.get(key));
    }

    @Override
    public boolean getBoolean(String key, boolean defaultValue) {
        return this.containsKey(key) ? this.getBoolean(key) : defaultValue;
    }

    @Override
    public Jsonb getArray(String key) {
        if (!(this.jsonValue instanceof JSONObject)) {
            throw new UnsupportedOperationException("Not an object: " + this.jsonValue);
        }
        JSONObject o = (JSONObject)this.jsonValue;
        return this.getArray(o.get(key));
    }

    @Override
    public Jsonb getObject(String key) {
        if (!(this.jsonValue instanceof JSONObject)) {
            throw new UnsupportedOperationException("Not an object: " + this.jsonValue);
        }
        JSONObject o = (JSONObject)this.jsonValue;
        return this.getObject(o.get(key));
    }

    @Override
    public boolean isNull(String key) {
        if (!(this.jsonValue instanceof JSONObject)) {
            throw new UnsupportedOperationException("Not an object: " + this.jsonValue);
        }
        JSONObject o = (JSONObject)this.jsonValue;
        return o.get(key) == null;
    }

    public int size() {
        if (this.jsonValue instanceof JSONArray) {
            return ((JSONArray)this.jsonValue).size();
        }
        if (this.jsonValue instanceof JSONObject) {
            return ((JSONObject)this.jsonValue).size();
        }
        throw new UnsupportedOperationException("Not an array or an object: " + this.jsonValue);
    }

    private Object getTypedValue(Object obj) {
        if (obj instanceof Long) {
            long l = (Long)obj;
            if (this.isInteger(l)) {
                return (int)l;
            }
            return l;
        }
        if (obj instanceof JSONArray) {
            JSONArray a = (JSONArray)obj;
            ArrayList<Object> newa = new ArrayList<Object>(a.size());
            for (Object e : a) {
                newa.add(this.getTypedValue(e));
            }
            return newa;
        }
        if (obj instanceof JSONObject) {
            JSONObject o = (JSONObject)obj;
            HashMap<String, Object> newo = new HashMap<String, Object>(o.size());
            Iterator iterator = o.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry _e;
                Map.Entry e = _e = iterator.next();
                newo.put((String)e.getKey(), this.getTypedValue(e.getValue()));
            }
            return newo;
        }
        return obj;
    }

    public Object getTypedValue() {
        return this.getTypedValue(this.jsonValue);
    }

    @Override
    public String toString() {
        return this.getValue();
    }
}

