/*
 * Decompiled with CFR 0.152.
 */
package net.bitnine.agensgraph.util;

import java.sql.SQLException;
import java.util.ArrayList;
import net.bitnine.agensgraph.deps.org.postgresql.util.PSQLException;
import net.bitnine.agensgraph.deps.org.postgresql.util.PSQLState;

public class AgTokenizer {
    private AgTokenizer() {
    }

    public static ArrayList<String> tokenize(String string) throws SQLException {
        int pos;
        ArrayList<String> tokens = new ArrayList<String>();
        int len = string.length() - 1;
        int start = pos;
        int depth = 0;
        boolean veid = false;
        String buffer = null;
        block8: for (pos = 1; pos < len; ++pos) {
            char c = string.charAt(pos);
            switch (c) {
                case '\"': {
                    if (depth <= 0) continue block8;
                    boolean escape = false;
                    for (int i = pos + 1; i < len; ++i) {
                        c = string.charAt(i);
                        if (c == '\\') {
                            escape = !escape;
                            continue;
                        }
                        if (c == '\"') {
                            if (escape) {
                                escape = false;
                                continue;
                            }
                            pos = i;
                            continue block8;
                        }
                        escape = false;
                    }
                    continue block8;
                }
                case '[': {
                    if (depth != 0) continue block8;
                    veid = true;
                    continue block8;
                }
                case ']': {
                    if (depth != 0) continue block8;
                    veid = false;
                    continue block8;
                }
                case '{': {
                    ++depth;
                    continue block8;
                }
                case '}': {
                    if (--depth >= 0) continue block8;
                    throw new PSQLException("Parsing graphpath failed", PSQLState.DATA_ERROR);
                }
                case ',': {
                    if (depth != 0 || veid) continue block8;
                    buffer = string.substring(start, pos);
                    if (buffer.isEmpty() || "NULL".equals(buffer)) {
                        tokens.add(null);
                    } else {
                        tokens.add(buffer);
                    }
                    start = pos + 1;
                    continue block8;
                }
            }
        }
        buffer = string.substring(start, pos);
        if (buffer.isEmpty() || "NULL".equals(buffer)) {
            tokens.add(null);
        } else {
            tokens.add(buffer);
        }
        return tokens;
    }
}

