/*
 * Decompiled with CFR 0.152.
 */
package net.bitnine.agensgraph.jdbc;

import java.lang.reflect.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import net.bitnine.agensgraph.deps.org.postgresql.Driver;
import net.bitnine.agensgraph.deps.org.postgresql.core.BaseConnection;
import net.bitnine.agensgraph.deps.org.postgresql.core.BaseStatement;
import net.bitnine.agensgraph.deps.org.postgresql.core.Field;
import net.bitnine.agensgraph.deps.org.postgresql.core.Tuple;
import net.bitnine.agensgraph.deps.org.postgresql.jdbc.PgArray;
import net.bitnine.agensgraph.deps.org.postgresql.util.GT;
import net.bitnine.agensgraph.deps.org.postgresql.util.PSQLException;
import net.bitnine.agensgraph.deps.org.postgresql.util.PSQLState;
import net.bitnine.agensgraph.util.AgTokenizer;

public class AgArray
extends PgArray {
    private final int oid;
    private ArrayList<String> arrayList;

    public AgArray(BaseConnection connection, int oid, String fieldString) throws SQLException {
        super(connection, oid, fieldString);
        this.oid = oid;
    }

    public AgArray(BaseConnection connection, int oid, byte[] fieldBytes) throws SQLException {
        super(connection, oid, fieldBytes);
        this.oid = oid;
    }

    @Override
    public Object getArrayImpl(long index, int count, Map<String, Class<?>> map) throws SQLException {
        if (map != null && !map.isEmpty()) {
            throw Driver.notImplemented(this.getClass(), "getArrayImpl(long,int,Map)");
        }
        if (index < 1L) {
            throw new PSQLException(GT.tr("The array index is out of range: {0}", index), PSQLState.DATA_ERROR);
        }
        if (this.fieldBytes != null) {
            throw new PSQLException(GT.tr("The type Binary is not supported.", new Object[0]), PSQLState.DATA_ERROR);
        }
        if (this.fieldString == null) {
            return null;
        }
        this.buildArrayList();
        if (count == 0) {
            count = this.arrayList.size();
        }
        if (--index + (long)count > (long)this.arrayList.size()) {
            throw new PSQLException(GT.tr("The array index is out of range: {0}, number of elements: {1}.", index + (long)count, this.arrayList.size()), PSQLState.DATA_ERROR);
        }
        return this.buildArray(this.arrayList, (int)index, count);
    }

    private void buildArrayList() throws SQLException {
        if (this.arrayList != null) {
            return;
        }
        this.arrayList = AgTokenizer.tokenize(this.fieldString);
    }

    private Object buildArray(ArrayList<String> input, int index, int count) throws SQLException {
        Object[] oa;
        if (count < 0) {
            count = input.size();
        }
        int length = 0;
        String typeName = this.getBaseTypeName();
        Object[] ret = oa = (Object[])Array.newInstance(this.connection.getTypeInfo().getPGobject(typeName), count);
        while (count > 0) {
            String v;
            oa[length++] = (v = input.get(index++)) == null ? null : this.connection.getObject(typeName, v, null);
            --count;
        }
        return ret;
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        this.buildArrayList();
        int elementOID = this.connection.getTypeInfo().getPGArrayElement(this.oid);
        return this.connection.getTypeInfo().getPGType(elementOID);
    }

    @Override
    public ResultSet getResultSetImpl(long index, int count, Map<String, Class<?>> map) throws SQLException {
        if (map != null && !map.isEmpty()) {
            throw Driver.notImplemented(this.getClass(), "getResultSetImpl(long,int,Map)");
        }
        if (index < 1L) {
            throw new PSQLException(GT.tr("The array index is out of range: {0}", index), PSQLState.DATA_ERROR);
        }
        if (this.fieldBytes != null) {
            throw new PSQLException(GT.tr("The type Binary is not supported.", new Object[0]), PSQLState.DATA_ERROR);
        }
        this.buildArrayList();
        if (count == 0) {
            count = this.arrayList.size();
        }
        if (--index + (long)count > (long)this.arrayList.size()) {
            throw new PSQLException(GT.tr("The array index is out of range: {0}, number of elements: {1},", index + (long)count, this.arrayList.size()), PSQLState.DATA_ERROR);
        }
        ArrayList<Tuple> tuples = new ArrayList<Tuple>();
        Field[] fields = new Field[2];
        int baseOid = this.connection.getTypeInfo().getPGArrayElement(this.oid);
        fields[0] = new Field("INDEX", 23);
        fields[1] = new Field("VALUE", baseOid);
        for (int i = 0; i < count; ++i) {
            int offset = (int)index + i;
            byte[][] t = new byte[2][0];
            String v = this.arrayList.get(offset);
            t[0] = this.connection.encodeString(Integer.toString(offset + 1));
            t[1] = v == null ? null : this.connection.encodeString(v);
            tuples.add(new Tuple(t));
        }
        BaseStatement stat = (BaseStatement)this.connection.createStatement(1004, 1007);
        return stat.createDriverResultSet(fields, tuples);
    }

    @Override
    public void free() throws SQLException {
        super.free();
        this.arrayList = null;
    }
}

