/*
 * Decompiled with CFR 0.152.
 */
package net.bitnine.agensgraph.graph;

import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.bitnine.agensgraph.deps.org.json.simple.JSONObject;
import net.bitnine.agensgraph.deps.org.postgresql.util.PSQLException;
import net.bitnine.agensgraph.deps.org.postgresql.util.PSQLState;
import net.bitnine.agensgraph.graph.GraphEntity;
import net.bitnine.agensgraph.graph.GraphId;
import net.bitnine.agensgraph.util.Jsonb;

public class Vertex
extends GraphEntity {
    private static final Pattern vertexPattern = Pattern.compile("(.+?)\\[(.+?)\\](.*)");

    public Vertex() {
        this.setType("vertex");
    }

    @Override
    public void setValue(String value) throws SQLException {
        Jsonb props;
        Matcher m = vertexPattern.matcher(value);
        if (m.find()) {
            this.setLabel(m.group(1));
            GraphId gid = new GraphId();
            gid.setValue(m.group(2));
            this.setGraphId(gid);
            props = new Jsonb();
            props.setValue(m.group(3));
            if (!(props.getJsonValue() instanceof JSONObject)) {
                throw new PSQLException("Parsing vertex failed", PSQLState.DATA_ERROR);
            }
        } else {
            throw new PSQLException("Parsing vertex failed", PSQLState.DATA_ERROR);
        }
        this.setProperties(props);
        super.setValue(value);
    }

    public GraphId getVertexId() {
        return this.getGraphId();
    }
}

