/*
 * Decompiled with CFR 0.152.
 */
package net.bitnine.agensgraph.graph;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import net.bitnine.agensgraph.deps.org.postgresql.util.PGobject;
import net.bitnine.agensgraph.graph.Edge;
import net.bitnine.agensgraph.graph.Vertex;
import net.bitnine.agensgraph.util.AgTokenizer;

public class Path
extends PGobject
implements Serializable,
Cloneable {
    private ArrayList<Vertex> vertices;
    private ArrayList<Edge> edges;

    public Path() {
        this.setType("graphpath");
    }

    @Override
    public void setValue(String value) throws SQLException {
        ArrayList<String> tokens = AgTokenizer.tokenize(value);
        ArrayList<Vertex> vertices = new ArrayList<Vertex>();
        ArrayList<Edge> edges = new ArrayList<Edge>();
        for (int i = 0; i < tokens.size(); ++i) {
            if (i % 2 == 0) {
                Vertex v = new Vertex();
                v.setValue(tokens.get(i));
                vertices.add(v);
                continue;
            }
            Edge e = new Edge();
            e.setValue(tokens.get(i));
            edges.add(e);
        }
        this.vertices = vertices;
        this.edges = edges;
        super.setValue(value);
    }

    public Iterable<Vertex> vertices() {
        return this.vertices;
    }

    public Iterable<Edge> edges() {
        return this.edges;
    }

    public int length() {
        return this.edges.size();
    }
}

