/*
 * Decompiled with CFR 0.152.
 */
package net.bitnine.agensgraph.graph;

import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.bitnine.agensgraph.deps.org.json.simple.JSONObject;
import net.bitnine.agensgraph.deps.org.postgresql.util.PSQLException;
import net.bitnine.agensgraph.deps.org.postgresql.util.PSQLState;
import net.bitnine.agensgraph.graph.GraphEntity;
import net.bitnine.agensgraph.graph.GraphId;
import net.bitnine.agensgraph.util.Jsonb;

public class Edge
extends GraphEntity {
    private static final Pattern edgePattern = Pattern.compile("(.+?)\\[(.+?)\\]\\[(.+?),(.+?)\\](.*)");
    private GraphId start;
    private GraphId end;

    public Edge() {
        this.setType("edge");
    }

    @Override
    public void setValue(String value) throws SQLException {
        Jsonb props;
        Matcher m = edgePattern.matcher(value);
        if (m.find()) {
            this.setLabel(m.group(1));
            GraphId gid = new GraphId();
            gid.setValue(m.group(2));
            this.setGraphId(gid);
            gid = new GraphId();
            gid.setValue(m.group(3));
            this.start = gid;
            gid = new GraphId();
            gid.setValue(m.group(4));
            this.end = gid;
            props = new Jsonb();
            props.setValue(m.group(5));
            if (!(props.getJsonValue() instanceof JSONObject)) {
                throw new PSQLException("Parsing edge failed", PSQLState.DATA_ERROR);
            }
        } else {
            throw new PSQLException("Parsing edge failed", PSQLState.DATA_ERROR);
        }
        this.setProperties(props);
        super.setValue(value);
    }

    public GraphId getEdgeId() {
        return this.getGraphId();
    }

    public GraphId getStartVertexId() {
        return this.start;
    }

    public GraphId getEndVertexId() {
        return this.end;
    }
}

