/*
 * Decompiled with CFR 0.152.
 */
package net.bitnine.agensgraph.deps.org.postgresql.replication;

import java.sql.SQLException;
import java.sql.Statement;
import net.bitnine.agensgraph.deps.org.postgresql.core.BaseConnection;
import net.bitnine.agensgraph.deps.org.postgresql.replication.PGReplicationConnection;
import net.bitnine.agensgraph.deps.org.postgresql.replication.fluent.ChainedCreateReplicationSlotBuilder;
import net.bitnine.agensgraph.deps.org.postgresql.replication.fluent.ChainedStreamBuilder;
import net.bitnine.agensgraph.deps.org.postgresql.replication.fluent.ReplicationCreateSlotBuilder;
import net.bitnine.agensgraph.deps.org.postgresql.replication.fluent.ReplicationStreamBuilder;

public class PGReplicationConnectionImpl
implements PGReplicationConnection {
    private BaseConnection connection;

    public PGReplicationConnectionImpl(BaseConnection connection) {
        this.connection = connection;
    }

    @Override
    public ChainedStreamBuilder replicationStream() {
        return new ReplicationStreamBuilder(this.connection);
    }

    @Override
    public ChainedCreateReplicationSlotBuilder createReplicationSlot() {
        return new ReplicationCreateSlotBuilder(this.connection);
    }

    @Override
    public void dropReplicationSlot(String slotName) throws SQLException {
        if (slotName == null || slotName.isEmpty()) {
            throw new IllegalArgumentException("Replication slot name can't be null or empty");
        }
        try (Statement statement = this.connection.createStatement();){
            statement.execute("DROP_REPLICATION_SLOT " + slotName);
        }
    }
}

