/*
 * Decompiled with CFR 0.152.
 */
package net.bitnine.agensgraph.deps.org.postgresql.hostchooser;

import net.bitnine.agensgraph.deps.org.postgresql.hostchooser.HostStatus;

public enum HostRequirement {
    any{

        @Override
        public boolean allowConnectingTo(HostStatus status) {
            return status != HostStatus.ConnectFail;
        }
    }
    ,
    master{

        @Override
        public boolean allowConnectingTo(HostStatus status) {
            return primary.allowConnectingTo(status);
        }
    }
    ,
    primary{

        @Override
        public boolean allowConnectingTo(HostStatus status) {
            return status == HostStatus.Primary || status == HostStatus.ConnectOK;
        }
    }
    ,
    secondary{

        @Override
        public boolean allowConnectingTo(HostStatus status) {
            return status == HostStatus.Secondary || status == HostStatus.ConnectOK;
        }
    }
    ,
    preferSecondary{

        @Override
        public boolean allowConnectingTo(HostStatus status) {
            return status != HostStatus.ConnectFail;
        }
    };


    public abstract boolean allowConnectingTo(HostStatus var1);

    public static HostRequirement getTargetServerType(String targetServerType) {
        String allowSlave = targetServerType.replace("lave", "econdary").replace("master", "primary");
        return HostRequirement.valueOf(allowSlave);
    }
}

