/*
 * Decompiled with CFR 0.152.
 */
package net.bitnine.agensgraph.deps.org.postgresql.gss;

import java.io.IOException;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.bitnine.agensgraph.deps.org.postgresql.core.PGStream;
import net.bitnine.agensgraph.deps.org.postgresql.gss.GssAction;
import net.bitnine.agensgraph.deps.org.postgresql.util.GT;
import net.bitnine.agensgraph.deps.org.postgresql.util.PSQLException;
import net.bitnine.agensgraph.deps.org.postgresql.util.PSQLState;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class GssEncAction
implements PrivilegedAction<Exception> {
    private static final Logger LOGGER = Logger.getLogger(GssAction.class.getName());
    private final PGStream pgStream;
    private final String host;
    private final String user;
    private final String kerberosServerName;
    private final boolean useSpnego;
    private final GSSCredential clientCredentials;
    private final boolean logServerErrorDetail;

    public GssEncAction(PGStream pgStream, GSSCredential clientCredentials, String host, String user, String kerberosServerName, boolean useSpnego, boolean logServerErrorDetail) {
        this.pgStream = pgStream;
        this.clientCredentials = clientCredentials;
        this.host = host;
        this.user = user;
        this.kerberosServerName = kerberosServerName;
        this.useSpnego = useSpnego;
        this.logServerErrorDetail = logServerErrorDetail;
    }

    private static boolean hasSpnegoSupport(GSSManager manager) throws GSSException {
        Oid[] mechs;
        Oid spnego = new Oid("1.3.6.1.5.5.2");
        for (Oid mech : mechs = manager.getMechs()) {
            if (!mech.equals(spnego)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Exception run() {
        try {
            GSSManager manager = GSSManager.getInstance();
            GSSCredential clientCreds = null;
            Oid[] desiredMechs = new Oid[1];
            if (this.clientCredentials == null) {
                desiredMechs[0] = this.useSpnego && GssEncAction.hasSpnegoSupport(manager) ? new Oid("1.3.6.1.5.5.2") : new Oid("1.2.840.113554.1.2.2");
                GSSName clientName = manager.createName(this.user, GSSName.NT_USER_NAME);
                clientCreds = manager.createCredential(clientName, 28800, desiredMechs, 1);
            } else {
                desiredMechs[0] = new Oid("1.2.840.113554.1.2.2");
                clientCreds = this.clientCredentials;
            }
            GSSName serverName = manager.createName(this.kerberosServerName + "@" + this.host, GSSName.NT_HOSTBASED_SERVICE);
            GSSContext secContext = manager.createContext(serverName, desiredMechs[0], clientCreds, 0);
            secContext.requestMutualAuth(true);
            secContext.requestConf(true);
            secContext.requestInteg(true);
            byte[] inToken = new byte[]{};
            byte[] outToken = null;
            boolean established = false;
            while (!established) {
                outToken = secContext.initSecContext(inToken, 0, inToken.length);
                if (outToken != null) {
                    LOGGER.log(Level.FINEST, " FE=> Password(GSS Authentication Token)");
                    this.pgStream.sendInteger4(outToken.length);
                    this.pgStream.send(outToken);
                    this.pgStream.flush();
                }
                if (!secContext.isEstablished()) {
                    int len = this.pgStream.receiveInteger4();
                    inToken = this.pgStream.receive(len);
                    continue;
                }
                established = true;
                this.pgStream.setSecContext(secContext);
            }
        }
        catch (IOException e) {
            return e;
        }
        catch (GSSException gsse) {
            return new PSQLException(GT.tr("GSS Authentication failed", new Object[0]), PSQLState.CONNECTION_FAILURE, (Throwable)gsse);
        }
        return null;
    }
}

