/*
 * Decompiled with CFR 0.152.
 */
package net.bitnine.agensgraph.deps.org.postgresql.core;

public class Tuple {
    private final boolean forUpdate;
    final byte[][] data;

    public Tuple(int length) {
        this(new byte[length][], true);
    }

    public Tuple(byte[][] data) {
        this(data, false);
    }

    private Tuple(byte[][] data, boolean forUpdate) {
        this.data = data;
        this.forUpdate = forUpdate;
    }

    public int fieldCount() {
        return this.data.length;
    }

    public int length() {
        int length = 0;
        for (byte[] field : this.data) {
            if (field == null) continue;
            length += field.length;
        }
        return length;
    }

    public byte[] get(int index) {
        return this.data[index];
    }

    public Tuple updateableCopy() {
        return this.copy(true);
    }

    public Tuple readOnlyCopy() {
        return this.copy(false);
    }

    private Tuple copy(boolean forUpdate) {
        byte[][] dataCopy = new byte[this.data.length][];
        System.arraycopy(this.data, 0, dataCopy, 0, this.data.length);
        return new Tuple(dataCopy, forUpdate);
    }

    public void set(int index, byte[] fieldData) {
        if (!this.forUpdate) {
            throw new IllegalArgumentException("Attempted to write to readonly tuple");
        }
        this.data[index] = fieldData;
    }
}

