/*
 * Decompiled with CFR 0.152.
 */
package net.bitnine.agensgraph.deps.org.postgresql.core;

import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.List;
import net.bitnine.agensgraph.deps.org.postgresql.core.Field;
import net.bitnine.agensgraph.deps.org.postgresql.core.Query;
import net.bitnine.agensgraph.deps.org.postgresql.core.ResultCursor;
import net.bitnine.agensgraph.deps.org.postgresql.core.ResultHandler;
import net.bitnine.agensgraph.deps.org.postgresql.core.Tuple;
import net.bitnine.agensgraph.deps.org.postgresql.util.internal.Nullness;

public class ResultHandlerBase
implements ResultHandler {
    private SQLException firstException;
    private SQLException lastException;
    private SQLWarning firstWarning;
    private SQLWarning lastWarning;

    @Override
    public void handleResultRows(Query fromQuery, Field[] fields, List<Tuple> tuples, ResultCursor cursor) {
    }

    @Override
    public void handleCommandStatus(String status, long updateCount, long insertOID) {
    }

    @Override
    public void secureProgress() {
    }

    @Override
    public void handleWarning(SQLWarning warning) {
        if (this.firstWarning == null) {
            this.firstWarning = this.lastWarning = warning;
            return;
        }
        SQLWarning lastWarning = Nullness.castNonNull(this.lastWarning);
        lastWarning.setNextException(warning);
        this.lastWarning = warning;
    }

    @Override
    public void handleError(SQLException error) {
        if (this.firstException == null) {
            this.firstException = this.lastException = error;
            return;
        }
        Nullness.castNonNull(this.lastException).setNextException(error);
        this.lastException = error;
    }

    @Override
    public void handleCompletion() throws SQLException {
        SQLException firstException = this.firstException;
        if (firstException != null) {
            throw firstException;
        }
    }

    @Override
    public SQLException getException() {
        return this.firstException;
    }

    @Override
    public SQLWarning getWarning() {
        return this.firstWarning;
    }
}

