/*
 * Decompiled with CFR 0.152.
 */
package net.billforward.model;

import com.google.gson.annotations.Expose;
import com.google.gson.reflect.TypeToken;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import net.billforward.BillForwardClient;
import net.billforward.exception.APIConnectionException;
import net.billforward.exception.APIException;
import net.billforward.exception.AuthenticationException;
import net.billforward.exception.CardException;
import net.billforward.exception.InvalidRequestException;
import net.billforward.model.APIResponse;
import net.billforward.model.BillingEntity;
import net.billforward.model.InvoiceLine;
import net.billforward.model.InvoicePayment;
import net.billforward.model.PricingComponent;
import net.billforward.model.PricingComponentValue;
import net.billforward.model.RatePlan;
import net.billforward.model.ResourcePath;
import net.billforward.model.Subscription;
import net.billforward.model.amendments.InvoiceNextExecutionAttemptAmendment;
import net.billforward.model.amendments.InvoiceRecalculationAmendment;
import net.billforward.model.amendments.IssueInvoiceAmendment;

public class Invoice
extends BillingEntity {
    @Expose
    protected String id;
    @Expose
    protected String versionID;
    @Expose
    protected String subscriptionID;
    @Expose
    protected String accountID;
    @Expose
    protected String organizationID;
    @Expose
    protected String state;
    @Expose
    protected Date periodStart;
    @Expose
    protected Date periodEnd;
    @Expose
    protected Boolean deleted = false;
    @Expose
    protected int totalExecutionAttempts;
    @Expose
    protected Date lastExecutionAttempt;
    @Expose
    protected Date nextExecutionAttempt;
    @Expose
    protected Date finalExecutionAttempt;
    @Expose
    protected Date paymentReceived;
    @Expose
    protected String currency;
    @Expose
    protected BigDecimal costExcludingTax;
    @Expose
    protected BigDecimal invoiceCost;
    @Expose
    protected BigDecimal invoicePaid;
    @Expose
    protected BigDecimal discountAmount;
    @Expose
    protected BigDecimal invoiceRefunded;
    @Expose
    protected String type;
    @Expose
    protected String locked;
    @Expose
    protected String managedBy;
    @Expose
    protected Boolean initialInvoice;
    @Expose
    protected int versionNumber;
    @Expose
    protected Date updated;
    @Expose
    protected String changedBy;
    @Expose
    protected Date created;
    protected InvoiceLine[] invoiceLines;
    protected InvoicePayment[] invoicePayments;
    protected static ResourcePath resourcePath = new ResourcePath("invoices", "invoice", new TypeToken<APIResponse<Invoice>>(){}.getType());

    public String getID() {
        return this.id;
    }

    public String getVersionID() {
        return this.versionID;
    }

    public String getSubscriptionID() {
        return this.subscriptionID;
    }

    public String getAccountID() {
        return this.accountID;
    }

    public String getOrganizationID() {
        return this.organizationID;
    }

    public String getStateAsString() {
        return this.state;
    }

    public InvoiceState getState() {
        return InvoiceState.valueOf(this.state);
    }

    public Date getPeriodStart() {
        return this.periodStart;
    }

    public Date getPeriodEnd() {
        return this.periodEnd;
    }

    public Boolean getDeleted() {
        return this.deleted;
    }

    public int getTotalExecutionAttempts() {
        return this.totalExecutionAttempts;
    }

    public Date getLastExecutionAttempt() {
        return this.lastExecutionAttempt;
    }

    public Date getNextExecutionAttempt() {
        return this.nextExecutionAttempt;
    }

    public Date getFinalExecutionAttempt() {
        return this.finalExecutionAttempt;
    }

    public Date getPaymentReceived() {
        return this.paymentReceived;
    }

    public String getCurrency() {
        return this.currency;
    }

    public BigDecimal getCostExcludingTax() {
        return this.costExcludingTax;
    }

    public BigDecimal getInvoiceCost() {
        return this.invoiceCost;
    }

    public BigDecimal getInvoicePaid() {
        return this.invoicePaid;
    }

    public BigDecimal getDiscountAmount() {
        return this.discountAmount;
    }

    public BigDecimal getInvoiceRefunded() {
        return this.invoiceRefunded;
    }

    public String getTypeAsString() {
        return this.type;
    }

    public InvoiceType getType() {
        return InvoiceType.valueOf(this.type);
    }

    public String getLocked() {
        return this.locked;
    }

    public String getManagedBy() {
        return this.managedBy;
    }

    public Boolean getInitialInvoice() {
        return this.initialInvoice;
    }

    public int getVersionNumber() {
        return this.versionNumber;
    }

    public Date getUpdated() {
        return this.updated;
    }

    public String getChangedBy() {
        return this.changedBy;
    }

    public Date getCreated() {
        return this.created;
    }

    public InvoiceLine[] getInvoiceLines() {
        return this.invoiceLines;
    }

    public InvoicePayment[] getInvoicePayments() {
        return this.invoicePayments;
    }

    public static Invoice getByID(String ID) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        Invoice[] invoices = (Invoice[])Invoice.getByID((String)ID, (ResourcePath)Invoice.ResourcePath());
        return invoices[0];
    }

    public static Invoice[] getBySubscriptionID(String subscriptionID) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return (Invoice[])Invoice.getByID((String)subscriptionID, (String)"subscription", (ResourcePath)Invoice.ResourcePath());
    }

    public static Invoice[] getByState(InvoiceState invoiceState_) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return (Invoice[])Invoice.getByID((String)invoiceState_.name(), (String)"state", (ResourcePath)Invoice.ResourcePath());
    }

    protected Invoice(BillForwardClient client_) {
        super(client_);
    }

    protected Invoice() {
    }

    protected ResourcePath getResourcePath() {
        return resourcePath;
    }

    protected static ResourcePath ResourcePath() {
        return resourcePath;
    }

    public InvoiceRecalculationAmendment recalculate() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.recalculate(this.getState());
    }

    public InvoiceRecalculationAmendment recalculate(InvoiceState newInvoiceState) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        InvoiceRecalculationAmendment amendment = new InvoiceRecalculationAmendment();
        amendment.setSubscriptionID(this.subscriptionID);
        amendment.setInvoiceID(this.id);
        amendment.setNewInvoiceState(newInvoiceState);
        amendment = InvoiceRecalculationAmendment.create(amendment);
        return amendment;
    }

    public InvoiceNextExecutionAttemptAmendment retryTakingPayment() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.retryTakingPayment(null);
    }

    public InvoiceNextExecutionAttemptAmendment retryTakingPayment(Date dateToExecute_) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        InvoiceNextExecutionAttemptAmendment amendment = new InvoiceNextExecutionAttemptAmendment();
        amendment.setSubscriptionID(this.subscriptionID);
        amendment.setInvoiceID(this.id);
        if (dateToExecute_ != null) {
            amendment.setActioningTime(dateToExecute_);
        }
        amendment = InvoiceNextExecutionAttemptAmendment.create(amendment);
        return amendment;
    }

    public IssueInvoiceAmendment issue() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        IssueInvoiceAmendment amendment = new IssueInvoiceAmendment();
        amendment.setSubscriptionID(this.subscriptionID);
        amendment.setInvoiceID(this.id);
        amendment = IssueInvoiceAmendment.create(amendment);
        return amendment;
    }

    public void setUsage(int usage) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        Subscription subscription = Subscription.getByID(this.subscriptionID);
        RatePlan ratePlan = subscription.getProductRatePlan();
        ArrayList<PricingComponentValue> newPricingComponentValues = new ArrayList<PricingComponentValue>();
        for (PricingComponent pricingComponent : ratePlan.getPricingComponents()) {
            if (pricingComponent.getChargeType() != PricingComponent.PricingComponentChargeType.usage) continue;
            PricingComponentValue value = new PricingComponentValue();
            value.setSubscriptionID(this.subscriptionID);
            value.setPricingComponentID(pricingComponent.getID());
            value.setValue(usage);
            value.setAppliesFrom(this.getPeriodStart());
            value.setAppliesTill(this.getPeriodStart());
            newPricingComponentValues.add(value);
        }
        for (PricingComponentValue value : newPricingComponentValues) {
            boolean update = false;
            for (PricingComponentValue currentValue : subscription.getPricingComponentValues()) {
                if (!currentValue.getAppliesFrom().equals(value.getAppliesFrom()) || !currentValue.getAppliesTill().equals(value.getAppliesTill())) continue;
                update = true;
                value = currentValue;
                break;
            }
            if (update) {
                value.save();
                continue;
            }
            PricingComponentValue.create(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum InvoiceState {
        Paid,
        Unpaid,
        Pending,
        Voided;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum InvoiceType {
        Subscription,
        Amendment,
        Adhoc,
        Trial,
        FinalArrears;

    }
}

