/*
 * Decompiled with CFR 0.152.
 */
package net.billforward.model.usage;

import com.google.gson.annotations.Expose;
import com.google.gson.reflect.TypeToken;
import java.util.Date;
import net.billforward.BillForwardClient;
import net.billforward.exception.APIConnectionException;
import net.billforward.exception.APIException;
import net.billforward.exception.AuthenticationException;
import net.billforward.exception.CardException;
import net.billforward.exception.InvalidRequestException;
import net.billforward.model.APIResponse;
import net.billforward.model.BillingEntity;
import net.billforward.model.InsertableEntity;
import net.billforward.model.ResourcePath;
import net.billforward.model.usage.UsageType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Usage
extends InsertableEntity<Usage> {
    @Expose
    protected String id;
    @Expose
    protected String organizationID;
    @Expose
    protected String sessiondID;
    @Expose
    protected String subscriptionID;
    @Expose
    protected String pricingComponentID;
    @Expose
    protected String pricingComponentName;
    @Expose
    protected String uom;
    @Expose
    protected int usagePeriod;
    @Expose
    protected long usageDuration;
    @Expose
    protected String usageType;
    @Expose
    protected long usageValue;
    @Expose
    protected Date start;
    @Expose
    protected Date stop;
    @Expose
    protected Date updated;
    protected static ResourcePath resourcePath = new ResourcePath("usage", "usage", new TypeToken<APIResponse<Usage>>(){}.getType());

    public String getID() {
        return this.id;
    }

    public String getOrganizationID() {
        return this.organizationID;
    }

    public String getSessiondID() {
        return this.sessiondID;
    }

    public String getSubscriptionID() {
        return this.subscriptionID;
    }

    public String getPricingComponentID() {
        return this.pricingComponentID;
    }

    public String getPricingComponentName() {
        return this.pricingComponentName;
    }

    public String getUom() {
        return this.uom;
    }

    public int getUsagePeriod() {
        return this.usagePeriod;
    }

    public long getUsageDuration() {
        return this.usageDuration;
    }

    public UsageType getUsageType() {
        return UsageType.valueOf(this.usageType);
    }

    public String getUsageTypeAsString() {
        return this.usageType;
    }

    public long getUsageValue() {
        return this.usageValue;
    }

    public Date getStart() {
        return this.start;
    }

    public Date getStop() {
        return this.stop;
    }

    public Date getUpdated() {
        return this.updated;
    }

    public void setSessiondID(String sessiondID) {
        this.sessiondID = sessiondID;
    }

    public void setSubscriptionID(String subscriptionID) {
        this.subscriptionID = subscriptionID;
    }

    public void setUom(String uom) {
        this.uom = uom;
    }

    public void setUsagePeriod(int usagePeriod) {
        this.usagePeriod = usagePeriod;
    }

    public void setUsageDuration(long usageDuration) {
        this.usageDuration = usageDuration;
    }

    public void setUsageType(UsageType usageType) {
        this.usageType = usageType.toString();
    }

    public void setUsageValue(long usageValue) {
        this.usageValue = usageValue;
    }

    public void setStart(Date start) {
        this.start = start;
    }

    public void setStop(Date stop) {
        this.stop = stop;
    }

    public static Usage create(Usage usage) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return ((Usage[])Usage.create((BillingEntity)usage, (ResourcePath)Usage.ResourcePath()))[0];
    }

    public static Usage[] getUsageForSubscription(String subscriptionID_) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return (Usage[])Usage.getByID((String)subscriptionID_, (ResourcePath)Usage.ResourcePath());
    }

    public static Usage[] getUsageForSubscriptionPeriod(String subscriptionID_, int period_) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return (Usage[])Usage.getByIDPostPath((String)subscriptionID_, (String)Integer.valueOf(period_).toString(), (ResourcePath)Usage.ResourcePath());
    }

    public Usage(BillForwardClient client_) {
        super(client_);
    }

    public Usage() {
    }

    @Override
    protected ResourcePath getResourcePath() {
        return resourcePath;
    }

    protected static ResourcePath ResourcePath() {
        return resourcePath;
    }
}

