/*
 * Decompiled with CFR 0.152.
 */
package net.billforward.model.usage;

import com.google.gson.annotations.Expose;
import com.google.gson.reflect.TypeToken;
import java.util.Date;
import net.billforward.BillForwardClient;
import net.billforward.exception.APIConnectionException;
import net.billforward.exception.APIException;
import net.billforward.exception.AuthenticationException;
import net.billforward.exception.CardException;
import net.billforward.exception.InvalidRequestException;
import net.billforward.model.APIResponse;
import net.billforward.model.BillingEntity;
import net.billforward.model.ResourcePath;
import net.billforward.model.usage.UsageState;
import net.billforward.model.usage.UsageType;

public class Period
extends BillingEntity {
    @Expose
    protected String subscriptionID;
    @Expose
    protected String organizationID;
    @Expose
    protected Date start;
    @Expose
    protected Date stop;
    @Expose
    protected int period;
    @Expose
    protected String usageType;
    @Expose
    protected String state;
    @Expose
    protected Date created;
    protected static ResourcePath resourcePath = new ResourcePath("periods", "period", new TypeToken<APIResponse<Period>>(){}.getType());

    public String getSubscriptionID() {
        return this.subscriptionID;
    }

    public String getOrganizationID() {
        return this.organizationID;
    }

    public Date getStart() {
        return this.start;
    }

    public Date getStop() {
        return this.stop;
    }

    public int getPeriod() {
        return this.period;
    }

    public String getUsageTypeAsString() {
        return this.usageType;
    }

    public UsageType getUsageType() {
        return UsageType.valueOf(this.usageType);
    }

    public String getStateAsString() {
        return this.state;
    }

    public UsageState getState() {
        return UsageState.valueOf(this.state);
    }

    public Date getCreated() {
        return this.created;
    }

    public static Period[] getPeriodsForSubscription(String subscriptionID_) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return (Period[])Period.getByID((String)subscriptionID_, (ResourcePath)Period.ResourcePath());
    }

    public static Period getLatestPeriodsForSubscription(String subscriptionID_) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        Period[] periods = (Period[])Period.getByID((String)subscriptionID_, (ResourcePath)Period.ResourcePath());
        if (periods == null || periods.length == 0) {
            return null;
        }
        Period latestPeriod = null;
        for (Period period : periods) {
            if (latestPeriod == null) {
                latestPeriod = period;
            }
            if (period.period <= latestPeriod.period) continue;
            latestPeriod = period;
        }
        return latestPeriod;
    }

    public static Period[] getAllPeriods() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return (Period[])Period.getAll((ResourcePath)Period.ResourcePath());
    }

    public Period(BillForwardClient client_) {
        super(client_);
    }

    protected Period() {
    }

    protected ResourcePath getResourcePath() {
        return resourcePath;
    }

    protected static ResourcePath ResourcePath() {
        return resourcePath;
    }
}

