/*
 * Decompiled with CFR 0.152.
 */
package net.billforward.model;

import com.google.gson.annotations.Expose;
import com.google.gson.reflect.TypeToken;
import java.math.BigDecimal;
import java.util.Currency;
import java.util.Date;
import net.billforward.BillForwardClient;
import net.billforward.exception.APIConnectionException;
import net.billforward.exception.APIException;
import net.billforward.exception.AuthenticationException;
import net.billforward.exception.CardException;
import net.billforward.exception.InvalidRequestException;
import net.billforward.model.APIResponse;
import net.billforward.model.BillingEntity;
import net.billforward.model.MutableEntity;
import net.billforward.model.ResourcePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaxationStrategy
extends MutableEntity<TaxationStrategy> {
    @Expose
    protected String id;
    @Expose
    protected String versionID;
    @Expose
    protected String organizationID;
    @Expose
    protected String country;
    @Expose
    protected String province;
    @Expose
    protected String currency;
    @Expose
    protected String name;
    @Expose
    protected BigDecimal percentage;
    @Expose
    protected boolean defaultTaxationStrategy;
    @Expose
    protected Date validTill;
    @Expose
    protected Date validFrom;
    @Expose
    protected Boolean deleted;
    @Expose
    protected Date updated;
    @Expose
    protected String changedBy;
    @Expose
    protected Date created;
    protected static ResourcePath resourcePath = new ResourcePath("taxation-strategies", "taxation-strategy", new TypeToken<APIResponse<TaxationStrategy>>(){}.getType());

    public String getID() {
        return this.id;
    }

    public String getCountryAsString() {
        return this.country;
    }

    public TaxationCountry getCountry() {
        return TaxationCountry.valueOf(this.country);
    }

    public void setCountry(TaxationCountry country) {
        this.country = country.toString();
    }

    public String getProvince() {
        return this.province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getCurrencyAsString() {
        return this.currency;
    }

    public Currency getCurrency() {
        return Currency.getInstance(this.currency);
    }

    public void setCurrency(Currency currency) {
        this.currency = currency.toString();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BigDecimal getPercentage() {
        return this.percentage;
    }

    public void setPercentage(BigDecimal percentage) {
        this.percentage = percentage;
    }

    public boolean isDefaultTaxationStrategy() {
        return this.defaultTaxationStrategy;
    }

    public void setDefaultTaxationStrategy(boolean defaultTaxationStrategy) {
        this.defaultTaxationStrategy = defaultTaxationStrategy;
    }

    public Date getValidTill() {
        return this.validTill;
    }

    public void setValidTill(Date validTill) {
        this.validTill = validTill;
    }

    public Date getValidFrom() {
        return this.validFrom;
    }

    public void setValidFrom(Date validFrom) {
        this.validFrom = validFrom;
    }

    public Boolean getDeleted() {
        return this.deleted;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public String getVersionID() {
        return this.versionID;
    }

    public String getOrganizationID() {
        return this.organizationID;
    }

    public Date getUpdated() {
        return this.updated;
    }

    public String getChangedBy() {
        return this.changedBy;
    }

    public Date getCreated() {
        return this.created;
    }

    public static TaxationStrategy create(TaxationStrategy taxationStrategy) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return ((TaxationStrategy[])TaxationStrategy.create((BillingEntity)taxationStrategy, (ResourcePath)TaxationStrategy.ResourcePath()))[0];
    }

    public static TaxationStrategy removeFromRatePlan(String ratePlanID, String taxationStrategyID) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        String path = String.format("product-rate-plans/%s/tax/%s", ratePlanID, taxationStrategyID);
        return (TaxationStrategy)TaxationStrategy.retireExplicitPath(path, TaxationStrategy.ResourcePath());
    }

    public static TaxationStrategy addToRatePlan(String ratePlanID, String taxationStrategyID) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        TaxationStrategy taxationStrategy = new TaxationStrategy();
        taxationStrategy.id = taxationStrategyID;
        String explicitPath = String.format("product-rate-plans/%s/tax", ratePlanID);
        return ((TaxationStrategy[])TaxationStrategy.createExplicitPath((BillingEntity)taxationStrategy, (ResourcePath)TaxationStrategy.ResourcePath(), (String)explicitPath))[0];
    }

    public static TaxationStrategy[] getForProductRatePlan(String ratePlanID) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        String path = String.format("product-rate-plans/%s/tax", ratePlanID);
        TaxationStrategy[] taxes = (TaxationStrategy[])TaxationStrategy.getAll((ResourcePath)TaxationStrategy.ResourcePath(), (String)path);
        if (taxes == null) {
            return new TaxationStrategy[0];
        }
        return taxes;
    }

    public static TaxationStrategy getByID(String ID) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        TaxationStrategy[] taxStrategies = (TaxationStrategy[])TaxationStrategy.getByID((String)ID, (ResourcePath)TaxationStrategy.ResourcePath());
        return taxStrategies[0];
    }

    public static TaxationStrategy getByVersionID(String ID) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        TaxationStrategy[] taxStrategies = (TaxationStrategy[])TaxationStrategy.getByID((String)ID, (String)"version", (ResourcePath)TaxationStrategy.ResourcePath());
        return taxStrategies[0];
    }

    public static TaxationStrategy[] getAll() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return (TaxationStrategy[])TaxationStrategy.getAll((ResourcePath)TaxationStrategy.ResourcePath());
    }

    public TaxationStrategy(BillForwardClient client_) {
        super(client_);
    }

    public TaxationStrategy() {
    }

    @Override
    protected ResourcePath getResourcePath() {
        return resourcePath;
    }

    protected static ResourcePath ResourcePath() {
        return resourcePath;
    }

    public void setID(String id) {
        this.id = id;
    }

    public TaxationStrategy retire() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return (TaxationStrategy)TaxationStrategy.retire(this.versionID, "version", this.getResourcePath());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TaxationCountry {
        UK,
        USA,
        Canada,
        Mexico,
        Brazil,
        Argentina,
        China,
        France,
        Germany,
        Ireland;

    }
}

