/*
 * Decompiled with CFR 0.152.
 */
package net.billforward.model;

import com.google.gson.annotations.Expose;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.billforward.BillForwardClient;
import net.billforward.exception.APIConnectionException;
import net.billforward.exception.APIException;
import net.billforward.exception.AuthenticationException;
import net.billforward.exception.CardException;
import net.billforward.exception.InvalidRequestException;
import net.billforward.model.APIResponse;
import net.billforward.model.BillingEntity;
import net.billforward.model.Coupon;
import net.billforward.model.MutableEntity;
import net.billforward.model.PaymentMethod;
import net.billforward.model.PricingComponentValue;
import net.billforward.model.RatePlan;
import net.billforward.model.ResourcePath;
import net.billforward.model.amendments.CancellationAmendment;
import net.billforward.model.amendments.ComponentChange;
import net.billforward.model.amendments.PricingComponentValueChangeAmendment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Subscription
extends MutableEntity<Subscription> {
    @Expose
    protected String id;
    @Expose
    protected String accountID;
    @Expose
    protected String organizationID;
    @Expose
    protected String productID;
    @Expose
    protected String productRatePlanID;
    @Expose
    protected String name;
    @Expose
    protected String description;
    @Expose
    protected String type;
    @Expose
    protected String state;
    @Expose
    protected Date currentPeriodStart;
    @Expose
    protected Date currentPeriodEnd;
    @Expose
    protected Date effectiveStartDate;
    @Expose
    protected Date actualStartDate;
    @Expose
    protected Date subscriptionEnd;
    @Expose
    protected Date currentPeriodEndExplicit;
    @Expose
    protected String locked;
    @Expose
    protected String managedBy;
    @Expose
    protected Date updated;
    @Expose
    protected String changedBy;
    @Expose
    protected Date created;
    @Expose
    protected RatePlan productRatePlan;
    @Expose
    protected List<PricingComponentValue> pricingComponentValues = new ArrayList<PricingComponentValue>();
    protected static ResourcePath resourcePath = new ResourcePath("subscriptions", "subscription", new TypeToken<APIResponse<Subscription>>(){}.getType());

    public String getID() {
        return this.id;
    }

    public String getAccountID() {
        return this.accountID;
    }

    public void setAccountID(String accountID) {
        this.accountID = accountID;
    }

    public String getProductID() {
        return this.productID;
    }

    public void setProductID(String productID) {
        this.productID = productID;
    }

    public String getProductRatePlanID() {
        return this.productRatePlanID;
    }

    public void setProductRatePlanID(String productRatePlanID) {
        this.productRatePlanID = productRatePlanID;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTypeAsString() {
        return this.type;
    }

    public SubscriptionType getType() {
        return SubscriptionType.valueOf(this.type);
    }

    public void setType(SubscriptionType type) {
        this.type = type.toString();
    }

    public String getStateAsString() {
        return this.state;
    }

    public SubscriptionState getState() {
        return SubscriptionState.valueOf(this.state);
    }

    public void setState(SubscriptionState state) {
        this.state = state.toString();
    }

    public Date getCurrentPeriodStart() {
        return this.currentPeriodStart;
    }

    public void setCurrentPeriodStart(Date currentPeriodStart) {
        this.currentPeriodStart = currentPeriodStart;
    }

    public Date getCurrentPeriodEnd() {
        return this.currentPeriodEnd;
    }

    public void setCurrentPeriodEnd(Date currentPeriodEnd) {
        this.currentPeriodEnd = currentPeriodEnd;
    }

    public Date getEffectiveStartDate() {
        return this.effectiveStartDate;
    }

    public void setEffectiveStartDate(Date effectiveStartDate) {
        this.effectiveStartDate = effectiveStartDate;
    }

    public Date getActualStartDate() {
        return this.actualStartDate;
    }

    public void setActualStartDate(Date actualStartDate) {
        this.actualStartDate = actualStartDate;
    }

    public Date getSubscriptionEnd() {
        return this.subscriptionEnd;
    }

    public void setSubscriptionEnd(Date subscriptionEnd) {
        this.subscriptionEnd = subscriptionEnd;
    }

    public Date getCurrentPeriodEndExplicit() {
        return this.currentPeriodEndExplicit;
    }

    public void setCurrentPeriodEndExplicit(Date currentPeriodEndExplicit) {
        this.currentPeriodEndExplicit = currentPeriodEndExplicit;
    }

    public String getManagedBy() {
        return this.managedBy;
    }

    public void setManagedBy(String managedBy) {
        this.managedBy = managedBy;
    }

    public Date getUpdated() {
        return this.updated;
    }

    public String getChangedBy() {
        return this.changedBy;
    }

    public Date getCreated() {
        return this.created;
    }

    public RatePlan getProductRatePlan() {
        if (this.productRatePlan == null) {
            try {
                this.productRatePlan = RatePlan.getByID(this.productRatePlanID);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.productRatePlan;
    }

    public List<PricingComponentValue> getPricingComponentValues() {
        return this.pricingComponentValues;
    }

    public void setPricingComponentValues(List<PricingComponentValue> pricingComponentValues) {
        this.pricingComponentValues = pricingComponentValues;
    }

    public static Subscription create(Subscription subscription) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return ((Subscription[])Subscription.create((BillingEntity)subscription, (ResourcePath)Subscription.ResourcePath()))[0];
    }

    public static Subscription getByID(String ID) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        Subscription[] subs = (Subscription[])Subscription.getByID((String)ID, (ResourcePath)Subscription.ResourcePath());
        if (subs == null || subs.length == 0) {
            return null;
        }
        return subs[0];
    }

    public static Subscription[] getByAccountID(String accountID) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return (Subscription[])Subscription.getByID((String)accountID, (String)"account", (ResourcePath)Subscription.ResourcePath());
    }

    public static Subscription[] getByState(SubscriptionState state_) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return (Subscription[])Subscription.getByID((String)state_.toString(), (String)"state", (ResourcePath)Subscription.ResourcePath());
    }

    public static Subscription[] getByRatePlanID(String ratePlanID) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return (Subscription[])Subscription.getByID((String)ratePlanID, (String)"product-rate-plan", (ResourcePath)Subscription.ResourcePath());
    }

    public static Subscription[] getByProductID(String productID) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return (Subscription[])Subscription.getByID((String)productID, (String)"product", (ResourcePath)Subscription.ResourcePath());
    }

    public static Subscription[] getAll() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return (Subscription[])Subscription.getAll((ResourcePath)Subscription.ResourcePath());
    }

    public Subscription(BillForwardClient client_) {
        super(client_);
    }

    public Subscription() {
    }

    @Override
    protected ResourcePath getResourcePath() {
        return resourcePath;
    }

    protected static ResourcePath ResourcePath() {
        return resourcePath;
    }

    public PaymentMethod[] getPaymentMethods() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return PaymentMethod.getForSubscription(this.id);
    }

    public PaymentMethod removePaymentMethod(String paymentMethodID) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return PaymentMethod.removeFromSubscription(this.id, paymentMethodID);
    }

    public PaymentMethod addPaymentMethod(String paymentMethodID) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return PaymentMethod.addToSubscription(this.id, paymentMethodID);
    }

    public CancellationAmendment cancelImmediately() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        CancellationAmendment amendment = new CancellationAmendment();
        amendment.setSubscriptionID(this.getID());
        amendment.setServiceEnd(CancellationAmendment.ServiceEndState.Immediate);
        amendment = CancellationAmendment.create(amendment);
        return amendment;
    }

    public CancellationAmendment cancelAtPeriodEnd() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        CancellationAmendment amendment = new CancellationAmendment();
        amendment.setSubscriptionID(this.getID());
        amendment.setServiceEnd(CancellationAmendment.ServiceEndState.AtPeriodEnd);
        amendment = CancellationAmendment.create(amendment);
        return amendment;
    }

    public PricingComponentValueChangeAmendment upgrade(String name, int newValue) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        HashMap<String, Integer> changes = new HashMap<String, Integer>();
        changes.put(name, newValue);
        return this.upgrade(changes);
    }

    public PricingComponentValueChangeAmendment upgrade(HashMap<String, Integer> changes_) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        PricingComponentValueChangeAmendment pricingComponentValueChangeAmendment = new PricingComponentValueChangeAmendment();
        for (Map.Entry<String, Integer> entry : changes_.entrySet()) {
            ComponentChange change = new ComponentChange(entry.getKey(), entry.getValue());
            pricingComponentValueChangeAmendment.addComponentChange(change);
        }
        pricingComponentValueChangeAmendment.setSubscriptionID(this.getID());
        return PricingComponentValueChangeAmendment.create(pricingComponentValueChangeAmendment);
    }

    public PricingComponentValueChangeAmendment upgrade(List<ComponentChange> changes_) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        PricingComponentValueChangeAmendment pricingComponentValueChangeAmendment = new PricingComponentValueChangeAmendment();
        for (ComponentChange change : changes_) {
            pricingComponentValueChangeAmendment.addComponentChange(change);
        }
        pricingComponentValueChangeAmendment.setSubscriptionID(this.getID());
        return PricingComponentValueChangeAmendment.create(pricingComponentValueChangeAmendment);
    }

    public Coupon addCouponCode(String couponCode) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Coupon.addCouponCodeToSubscription(couponCode, this.id);
    }

    public Coupon[] getCouponCodes() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Coupon.getCouponsForSubscription(this.id);
    }

    public Coupon removeCouponCode(String couponCode) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Coupon.removeCouponCode(couponCode);
    }

    public PricingComponentValue[] getActivePricingComponentValues() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return PricingComponentValue.getActiveForSubscription(this.id);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SubscriptionState {
        Trial,
        Provisioned,
        Paid,
        AwaitingPayment,
        Cancelled,
        Failed,
        Expired;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SubscriptionType {
        Adhoc,
        Subscription,
        FixedTerm,
        Trial;

    }
}

