/*
 * Decompiled with CFR 0.152.
 */
package net.billforward.model;

import com.google.gson.annotations.Expose;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Currency;
import java.util.Date;
import java.util.List;
import net.billforward.BillForwardClient;
import net.billforward.exception.APIConnectionException;
import net.billforward.exception.APIException;
import net.billforward.exception.AuthenticationException;
import net.billforward.exception.CardException;
import net.billforward.exception.InvalidRequestException;
import net.billforward.model.APIResponse;
import net.billforward.model.BillingEntity;
import net.billforward.model.FixedTermDefinition;
import net.billforward.model.MutableEntity;
import net.billforward.model.PricingComponent;
import net.billforward.model.Product;
import net.billforward.model.ResourcePath;
import net.billforward.model.TaxationStrategy;
import net.billforward.model.usage.UsageRoundingStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RatePlan
extends MutableEntity<RatePlan> {
    @Expose
    protected String id;
    @Expose
    protected String productID;
    @Expose
    protected String name;
    @Expose
    protected String organizationID;
    @Expose
    protected String currency;
    @Expose
    protected String taxStatus;
    @Expose
    protected String proRataMode;
    @Expose
    protected Boolean localisedTax;
    @Expose
    protected Date validFrom;
    @Expose
    protected Date validTill;
    @Expose
    protected String status;
    @Expose
    protected Boolean deleted;
    @Expose
    protected Date updated;
    @Expose
    protected String changedBy;
    @Expose
    protected Date created;
    protected Product product;
    @Expose
    protected List<PricingComponent> pricingComponents = new ArrayList<PricingComponent>();
    @Expose
    protected List<FixedTermDefinition> fixedTermDefinitions = new ArrayList<FixedTermDefinition>();
    @Expose
    protected UsageRoundingStrategy strategy;
    protected static ResourcePath resourcePath = new ResourcePath("product-rate-plans", "productRatePlan", new TypeToken<APIResponse<RatePlan>>(){}.getType());

    public TaxationStrategy[] getTax() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return TaxationStrategy.getForProductRatePlan(this.id);
    }

    public String getID() {
        return this.id;
    }

    public String getProductID() {
        return this.productID;
    }

    public void setProductID(String productID) {
        this.productID = productID;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getOrganizationID() {
        return this.organizationID;
    }

    public void setOrganizationID(String organizationID) {
        this.organizationID = organizationID;
    }

    public String getCurrencyAsString() {
        return this.currency;
    }

    public Currency getCurrency() {
        return Currency.getInstance(this.currency);
    }

    public void setCurrency(Currency currency) {
        this.currency = currency.toString();
    }

    public TaxStatus getTaxStatus() {
        return TaxStatus.valueOf(this.taxStatus);
    }

    public String getTaxStatusAsString() {
        return this.taxStatus;
    }

    public void setTaxStatus(TaxStatus taxStatus) {
        this.taxStatus = taxStatus.toString();
    }

    public String getProRataMode() {
        return this.proRataMode;
    }

    public void setProRataMode(String proRataMode) {
        this.proRataMode = proRataMode;
    }

    public Boolean getLocalisedTax() {
        return this.localisedTax;
    }

    public void setLocalisedTax(Boolean localisedTax) {
        this.localisedTax = localisedTax;
    }

    public Date getValidFrom() {
        return this.validFrom;
    }

    public void setValidFrom(Date validFrom) {
        this.validFrom = validFrom;
    }

    public Date getValidTill() {
        return this.validTill;
    }

    public void setValidTill(Date validTill) {
        this.validTill = validTill;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Boolean getDeleted() {
        return this.deleted;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public Date getUpdated() {
        return this.updated;
    }

    public void setUpdated(Date updated) {
        this.updated = updated;
    }

    public String getChangedBy() {
        return this.changedBy;
    }

    public Date getCreated() {
        return this.created;
    }

    public Product getProduct() {
        return this.product;
    }

    public List<PricingComponent> getPricingComponents() {
        return this.pricingComponents;
    }

    public UsageRoundingStrategy getUsageRoundingStrategy() {
        return this.strategy;
    }

    public void setUsageRoundingStrategy(UsageRoundingStrategy strategy) {
        this.strategy = strategy;
    }

    public PricingComponent[] getLatestPricingComponents() {
        ArrayList<PricingComponent> latestPricingComponents = new ArrayList<PricingComponent>();
        for (PricingComponent pricingComponent : this.pricingComponents) {
            if (pricingComponent.validTill != null) continue;
            latestPricingComponents.add(pricingComponent);
        }
        return latestPricingComponents.toArray(new PricingComponent[0]);
    }

    public RatePlan retire() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return (RatePlan)RatePlan.retire(this.getID(), RatePlan.ResourcePath());
    }

    public static RatePlan create(RatePlan ratePlan) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return ((RatePlan[])RatePlan.create((BillingEntity)ratePlan, (ResourcePath)RatePlan.ResourcePath()))[0];
    }

    public static RatePlan getByID(String ID) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        RatePlan[] rateplans = (RatePlan[])RatePlan.getByID((String)ID, (ResourcePath)RatePlan.ResourcePath());
        return rateplans[0];
    }

    public static RatePlan[] getByProductID(String productID) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return (RatePlan[])RatePlan.getByID((String)productID, (String)"product", (ResourcePath)RatePlan.ResourcePath());
    }

    public static RatePlan[] getAll() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return (RatePlan[])RatePlan.getAll((ResourcePath)RatePlan.ResourcePath());
    }

    public TaxationStrategy addTax(String taxationStrategyID) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return TaxationStrategy.addToRatePlan(this.id, taxationStrategyID);
    }

    public TaxationStrategy removeTax(String taxationStrategyID) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return RatePlan.removeTax(this.id, taxationStrategyID);
    }

    public static TaxationStrategy removeTax(String ratePlanID, String taxationStrategyID) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return TaxationStrategy.removeFromRatePlan(ratePlanID, taxationStrategyID);
    }

    public RatePlan(BillForwardClient client_) {
        super(client_);
    }

    public RatePlan() {
    }

    @Override
    protected ResourcePath getResourcePath() {
        return resourcePath;
    }

    protected static ResourcePath ResourcePath() {
        return resourcePath;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ProRataMode {
        None,
        WithCoupon,
        WithoutCoupon,
        Full;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TaxStatus {
        inclusive,
        exclusive;

    }
}

