/*
 * Decompiled with CFR 0.152.
 */
package net.billforward.model;

import com.google.gson.reflect.TypeToken;
import net.billforward.BillForwardClient;
import net.billforward.exception.APIConnectionException;
import net.billforward.exception.APIException;
import net.billforward.exception.AuthenticationException;
import net.billforward.exception.CardException;
import net.billforward.exception.InvalidRequestException;
import net.billforward.model.APIResponse;
import net.billforward.model.BillingEntity;
import net.billforward.model.PriceCalculation;
import net.billforward.model.PriceRequest;
import net.billforward.model.ResourcePath;

public class PricingCalculator
extends BillingEntity {
    protected static ResourcePath resourcePath = new ResourcePath("pricing-calculator", "priceCalculation", new TypeToken<APIResponse<PriceCalculation>>(){}.getType());

    public static PriceCalculation requestPriceCalculation(PriceRequest priceRequest_) throws APIException, AuthenticationException, InvalidRequestException, APIConnectionException, CardException {
        ResourcePath path;
        String apiRoute;
        String url;
        BillForwardClient client = BillForwardClient.getClient();
        APIResponse resp = (APIResponse)client.requestUntyped(BillForwardClient.RequestMethod.POST, url = String.format("%s/%s", apiRoute = (path = PricingCalculator.ResourcePath()).getPath(), "product-rate-plan"), priceRequest_, path.getResponseType());
        if (resp == null || resp.results == null || ((PriceCalculation[])resp.results).length < 1) {
            return null;
        }
        for (PriceCalculation res : (PriceCalculation[])resp.results) {
            res.setClient(client);
        }
        return ((PriceCalculation[])resp.results)[0];
    }

    public PricingCalculator(BillForwardClient client_) {
        super(client_);
    }

    protected PricingCalculator() {
    }

    protected ResourcePath getResourcePath() {
        return resourcePath;
    }

    protected static ResourcePath ResourcePath() {
        return resourcePath;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PriceRequestCodeType {
        instance,
        book,
        instanceID,
        bookID;

    }
}

