/*
 * Decompiled with CFR 0.152.
 */
package net.billforward.model;

import com.google.gson.annotations.Expose;
import com.google.gson.reflect.TypeToken;
import java.util.Date;
import net.billforward.BillForwardClient;
import net.billforward.exception.APIConnectionException;
import net.billforward.exception.APIException;
import net.billforward.exception.AuthenticationException;
import net.billforward.exception.CardException;
import net.billforward.exception.InvalidRequestException;
import net.billforward.model.APIResponse;
import net.billforward.model.BillingEntity;
import net.billforward.model.CardType;
import net.billforward.model.MutableEntity;
import net.billforward.model.PaymentGateway;
import net.billforward.model.ResourcePath;
import net.billforward.model.tokenization.StripeTokenCapture;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PaymentMethod
extends MutableEntity<PaymentMethod> {
    @Expose
    protected String id;
    @Expose
    protected String accountID;
    @Expose
    protected String organizationID;
    @Expose
    protected String name;
    @Expose
    protected String description;
    @Expose
    protected String cardHolderName;
    @Expose
    protected String expiryDate;
    @Expose
    protected String cardType;
    @Expose
    protected String gateway;
    @Expose
    protected String linkID = "";
    @Expose
    protected int priority;
    @Expose
    protected Boolean defaultPaymentMethod;
    @Expose
    protected Boolean reusable;
    @Expose
    protected Boolean deleted;
    @Expose
    protected Date updated;
    @Expose
    protected String changedBy;
    @Expose
    protected Date created;
    protected static ResourcePath resourcePath = new ResourcePath("payment-methods", "paymentMethod", new TypeToken<APIResponse<PaymentMethod>>(){}.getType());

    public String getID() {
        return this.id;
    }

    public String getAccountID() {
        return this.accountID;
    }

    public void setAccountID(String accountID) {
        this.accountID = accountID;
    }

    public String getOrganizationID() {
        return this.organizationID;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCardHolderName() {
        return this.cardHolderName;
    }

    public void setCardHolderName(String cardHolderName) {
        this.cardHolderName = cardHolderName;
    }

    public String getExpiryDate() {
        return this.expiryDate;
    }

    public void setExpiryDate(String expiryDate) {
        this.expiryDate = expiryDate;
    }

    public String getCardTypeAsString() {
        return this.cardType;
    }

    public CardType getCardType() {
        return CardType.valueOf(this.cardType);
    }

    public void setCardType(CardType cardType) {
        this.cardType = cardType.toString();
    }

    public String getPaymentGatewayAsString() {
        return this.gateway;
    }

    public PaymentGateway getGateway() {
        return PaymentGateway.valueOf(this.gateway);
    }

    public void setGateway(PaymentGateway cardType) {
        this.gateway = cardType.toString();
    }

    public String getLinkID() {
        return this.linkID;
    }

    public void setLinkID(String linkID) {
        this.linkID = linkID;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public Boolean getDefaultPaymentMethod() {
        return this.defaultPaymentMethod;
    }

    public void setDefaultPaymentMethod(Boolean defaultPaymentMethod) {
        this.defaultPaymentMethod = defaultPaymentMethod;
    }

    public Boolean getReusable() {
        return this.reusable;
    }

    public void setReusable(Boolean reusable) {
        this.reusable = reusable;
    }

    public Boolean getDeleted() {
        return this.deleted;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public Date getUpdated() {
        return this.updated;
    }

    public String getChangedBy() {
        return this.changedBy;
    }

    public Date getCreated() {
        return this.created;
    }

    public static PaymentMethod create(PaymentMethod paymentMethod) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return ((PaymentMethod[])PaymentMethod.create((BillingEntity)paymentMethod, (ResourcePath)PaymentMethod.ResourcePath()))[0];
    }

    public static PaymentMethod getByID(String ID) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        PaymentMethod[] paymentMethods = (PaymentMethod[])PaymentMethod.getByID((String)ID, (ResourcePath)PaymentMethod.ResourcePath());
        return paymentMethods[0];
    }

    public PaymentMethod(BillForwardClient client_) {
        super(client_);
    }

    public PaymentMethod() {
    }

    @Override
    public ResourcePath getResourcePath() {
        return resourcePath;
    }

    public static ResourcePath ResourcePath() {
        return resourcePath;
    }

    public static PaymentMethod capture(StripeTokenCapture token_) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return token_.create();
    }

    public static PaymentMethod addToSubscription(String subscriptionID, String paymentMethodID) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        PaymentMethod paymentMethod = new PaymentMethod();
        paymentMethod.id = paymentMethodID;
        String explicitPath = String.format("subscriptions/%s/payment-methods", subscriptionID);
        return ((PaymentMethod[])PaymentMethod.createExplicitPath((BillingEntity)paymentMethod, (ResourcePath)PaymentMethod.ResourcePath(), (String)explicitPath))[0];
    }

    public static PaymentMethod removeFromSubscription(String subscriptionID, String paymentMethodID) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        String path = String.format("subscriptions/%s/payment-methods/%s", subscriptionID, paymentMethodID);
        return (PaymentMethod)PaymentMethod.retireExplicitPath(path, PaymentMethod.ResourcePath());
    }

    public static PaymentMethod[] getForSubscription(String subscriptionID) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        String path = String.format("subscriptions/%s/payment-methods", subscriptionID);
        PaymentMethod[] paymentMethods = (PaymentMethod[])PaymentMethod.getAll((ResourcePath)PaymentMethod.ResourcePath(), (String)path);
        if (paymentMethods == null) {
            return new PaymentMethod[0];
        }
        return paymentMethods;
    }
}

