/*
 * Decompiled with CFR 0.152.
 */
package net.billforward.model.usage;

import com.google.gson.annotations.Expose;
import com.google.gson.reflect.TypeToken;
import java.util.Date;
import net.billforward.BillForwardClient;
import net.billforward.exception.APIConnectionException;
import net.billforward.exception.APIException;
import net.billforward.exception.AuthenticationException;
import net.billforward.exception.CardException;
import net.billforward.exception.InvalidRequestException;
import net.billforward.model.APIResponse;
import net.billforward.model.BillingEntity;
import net.billforward.model.ResourcePath;
import net.billforward.model.usage.DurationResolution;
import net.billforward.model.usage.UsageType;

public class UsagePeriod
extends BillingEntity {
    @Expose
    protected String id;
    @Expose
    protected String organizationID;
    @Expose
    protected String sessiondID;
    @Expose
    protected String subscriptionID;
    @Expose
    protected String pricingComponentID;
    @Expose
    protected String pricingComponentName;
    @Expose
    protected String uom;
    @Expose
    protected String invoiceID;
    @Expose
    protected Date state;
    @Expose
    protected int period;
    @Expose
    protected Date start;
    @Expose
    protected String stop;
    @Expose
    protected String durationResolution;
    @Expose
    protected String usageDuration;
    @Expose
    protected long usageValue;
    @Expose
    protected String usageType;
    protected static ResourcePath resourcePath = new ResourcePath("usage-periods", "usagePeriod", new TypeToken<APIResponse<UsagePeriod>>(){}.getType());

    public String getID() {
        return this.id;
    }

    public String getOrganizationID() {
        return this.organizationID;
    }

    public String getSessiondID() {
        return this.sessiondID;
    }

    public String getSubscriptionID() {
        return this.subscriptionID;
    }

    public String getPricingComponentID() {
        return this.pricingComponentID;
    }

    public String getPricingComponentName() {
        return this.pricingComponentName;
    }

    public String getUom() {
        return this.uom;
    }

    public String getInvoiceID() {
        return this.invoiceID;
    }

    public Date getState() {
        return this.state;
    }

    public int getPeriod() {
        return this.period;
    }

    public Date getStart() {
        return this.start;
    }

    public String getStop() {
        return this.stop;
    }

    public String getDurationResolutionAsString() {
        return this.durationResolution;
    }

    public DurationResolution getDurationResolution() {
        return DurationResolution.valueOf(this.durationResolution);
    }

    public String getUsageDuration() {
        return this.usageDuration;
    }

    public long getUsageValue() {
        return this.usageValue;
    }

    public String getUsageTypeAsString() {
        return this.usageType;
    }

    public UsageType getUsageType() {
        return UsageType.valueOf(this.usageType);
    }

    public static UsagePeriod[] getUsagePeriodsForSubscription(String subscriptionID_) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return (UsagePeriod[])UsagePeriod.getByID((String)subscriptionID_, (ResourcePath)UsagePeriod.ResourcePath());
    }

    public static UsagePeriod[] getUsagePeriodsForInvoice(String subscriptionID_, String invoiceID_) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        String postPath = String.format("invoice/%s", invoiceID_);
        return (UsagePeriod[])UsagePeriod.getByIDPostPath((String)subscriptionID_, (String)postPath, (ResourcePath)UsagePeriod.ResourcePath());
    }

    public static UsagePeriod[] getUsagePeriodsForSubscriptionPeriod(String subscriptionID_, int period_) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return (UsagePeriod[])UsagePeriod.getByIDPostPath((String)subscriptionID_, (String)Integer.valueOf(period_).toString(), (ResourcePath)UsagePeriod.ResourcePath());
    }

    public UsagePeriod(BillForwardClient client_) {
        super(client_);
    }

    protected UsagePeriod() {
    }

    @Override
    protected ResourcePath getResourcePath() {
        return resourcePath;
    }

    protected static ResourcePath ResourcePath() {
        return resourcePath;
    }
}

