/*
 * Decompiled with CFR 0.152.
 */
package net.billforward.model.amendments;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import net.billforward.BillForwardClient;
import net.billforward.exception.APIConnectionException;
import net.billforward.exception.APIException;
import net.billforward.exception.AuthenticationException;
import net.billforward.exception.CardException;
import net.billforward.exception.InvalidRequestException;
import net.billforward.model.APIResponse;
import net.billforward.model.BillingEntity;
import net.billforward.model.ResourcePath;
import net.billforward.model.amendments.Amendment;

public class IssueInvoiceAmendment
extends Amendment {
    @SerializedName(value="@type")
    @Expose
    protected String amendmentType = Amendment.AmendmentType.IssueInvoiceAmendment.toString();
    @Expose
    String invoiceID;
    protected static ResourcePath resourcePath = new ResourcePath("amendments", "amendments", new TypeToken<APIResponse<IssueInvoiceAmendment>>(){}.getType());

    public String getAmendmentTypeAsString() {
        return this.amendmentType;
    }

    public Amendment.AmendmentType getAmendmentType() {
        return Amendment.AmendmentType.valueOf(this.amendmentType);
    }

    public String getInvoiceID() {
        return this.invoiceID;
    }

    public void setInvoiceID(String invoiceID) {
        this.invoiceID = invoiceID;
    }

    public static IssueInvoiceAmendment create(IssueInvoiceAmendment amendment) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return ((IssueInvoiceAmendment[])IssueInvoiceAmendment.create((BillingEntity)amendment, (ResourcePath)IssueInvoiceAmendment.ResourcePath()))[0];
    }

    public IssueInvoiceAmendment(BillForwardClient client_) {
        super(client_);
    }

    public IssueInvoiceAmendment() {
    }

    @Override
    protected ResourcePath getResourcePath() {
        return resourcePath;
    }

    protected static ResourcePath ResourcePath() {
        return resourcePath;
    }

    public static IssueInvoiceAmendment get(String ID) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        IssueInvoiceAmendment[] amendments = (IssueInvoiceAmendment[])IssueInvoiceAmendment.getByID((String)ID, (ResourcePath)IssueInvoiceAmendment.ResourcePath());
        if (amendments == null || amendments.length == 0) {
            return null;
        }
        return amendments[0];
    }

    public IssueInvoiceAmendment sync() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        IssueInvoiceAmendment amendment = this;
        int maxQuery = 60;
        while (amendment.getState() == Amendment.AmendmentState.Pending) {
            amendment = IssueInvoiceAmendment.get(amendment.getID());
            if (--maxQuery <= 0) break;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
        return amendment;
    }
}

