/*
 * Decompiled with CFR 0.152.
 */
package net.billforward.model;

import com.google.gson.annotations.Expose;
import com.google.gson.reflect.TypeToken;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import net.billforward.BillForwardClient;
import net.billforward.exception.APIConnectionException;
import net.billforward.exception.APIException;
import net.billforward.exception.AuthenticationException;
import net.billforward.exception.CardException;
import net.billforward.exception.InvalidRequestException;
import net.billforward.model.APIResponse;
import net.billforward.model.InsertableEntity;
import net.billforward.model.QuoteBreakdownCost;
import net.billforward.model.QuoteBreakdownDiscount;
import net.billforward.model.QuoteRequest;
import net.billforward.model.QuoteType;
import net.billforward.model.ResourcePath;

public class Quote
extends InsertableEntity<QuoteRequest> {
    @Expose
    protected BigDecimal subtotal;
    @Expose
    protected BigDecimal total;
    @Expose
    protected BigDecimal tax;
    @Expose
    protected BigDecimal discount;
    @Expose
    protected String currency;
    @Expose
    protected String productName;
    @Expose
    protected String productRatePlanName;
    @Expose
    protected String productID;
    @Expose
    protected String productRatePlanID;
    @Expose
    protected String subscriptionID;
    @Expose
    protected String accountID;
    @Expose
    protected List<QuoteBreakdownCost> quantities;
    @Expose
    protected List<QuoteBreakdownDiscount> discounts;
    @Expose
    protected QuoteType quoteFor = QuoteType.RecurringPeriod;
    @Expose
    protected Date periodStart;
    @Expose
    protected Date periodEnd;
    @Expose
    protected BigDecimal totalPeriods;
    @Expose
    protected boolean prorationEnabled;
    @Expose
    protected BigDecimal uplift;
    protected static ResourcePath resourcePath = new ResourcePath("quotes", "quotes", new TypeToken<APIResponse<Quote>>(){}.getType());

    public static Quote create(QuoteRequest quoteRequest) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        BillForwardClient client = BillForwardClient.getClient();
        APIResponse response = (APIResponse)client.requestUntyped(BillForwardClient.RequestMethod.POST, resourcePath.getPath(), quoteRequest, resourcePath.getResponseType());
        return ((Quote[])response.getResults())[0];
    }

    @Override
    protected ResourcePath getResourcePath() {
        return resourcePath;
    }

    public static ResourcePath ResourcePath() {
        return resourcePath;
    }
}

