/*
 * Decompiled with CFR 0.152.
 */
package net.billforward.model;

import com.google.gson.annotations.Expose;
import com.google.gson.reflect.TypeToken;
import java.util.Date;
import java.util.List;
import net.billforward.BillForwardClient;
import net.billforward.exception.APIConnectionException;
import net.billforward.exception.APIException;
import net.billforward.exception.AuthenticationException;
import net.billforward.exception.CardException;
import net.billforward.exception.InvalidRequestException;
import net.billforward.model.APIResponse;
import net.billforward.model.DunningLine;
import net.billforward.model.MutableEntity;
import net.billforward.model.OrganizationGateway;
import net.billforward.model.ResourcePath;
import net.billforward.model.TaxationStrategy;
import net.billforward.model.Webhook;
import net.billforward.model.gateways.APIConfiguration;

public class Organization
extends MutableEntity<Organization> {
    @Expose
    protected String id;
    @Expose
    protected String name;
    @Expose
    protected boolean deleted;
    @Expose
    protected Date updated;
    @Expose
    protected String changedBy;
    @Expose
    protected Date created;
    @Expose
    protected List<Webhook> webhooks;
    @Expose
    protected List<DunningLine> dunningLines;
    @Expose
    protected List<APIConfiguration> apiConfigurations;
    @Expose
    protected List<TaxationStrategy> taxationStrategies;
    @Expose
    protected List<OrganizationGateway> organizationGateways;
    protected static ResourcePath resourcePath = new ResourcePath("organizations", "organization", new TypeToken<APIResponse<Organization>>(){}.getType());

    public String getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public Date getUpdated() {
        return this.updated;
    }

    public String getChangedBy() {
        return this.changedBy;
    }

    public Date getCreated() {
        return this.created;
    }

    public List<Webhook> getWebhooks() {
        return this.webhooks;
    }

    public List<DunningLine> getDunningLines() {
        return this.dunningLines;
    }

    public List<APIConfiguration> getApiConfigurations() {
        return this.apiConfigurations;
    }

    public List<TaxationStrategy> getTaxationStrategies() {
        return this.taxationStrategies;
    }

    public List<OrganizationGateway> getOrganizationGateways() {
        return this.organizationGateways;
    }

    public static Organization getMine() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        Organization[] orgs = (Organization[])Organization.getByID((String)"mine", (ResourcePath)Organization.ResourcePath());
        return orgs[0];
    }

    public static Organization getByID(String ID) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        Organization[] orgs = (Organization[])Organization.getByID((String)ID, (ResourcePath)Organization.ResourcePath());
        return orgs[0];
    }

    public static Webhook[] getAll() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return (Webhook[])Organization.getAll((ResourcePath)Organization.ResourcePath());
    }

    protected Organization(BillForwardClient client_) {
        super(client_);
    }

    protected Organization() {
    }

    @Override
    protected ResourcePath getResourcePath() {
        return resourcePath;
    }

    protected static ResourcePath ResourcePath() {
        return resourcePath;
    }
}

