/*
 * Decompiled with CFR 0.152.
 */
package net.billforward.model;

import com.google.gson.annotations.Expose;
import com.google.gson.reflect.TypeToken;
import net.billforward.BillForwardClient;
import net.billforward.exception.APIConnectionException;
import net.billforward.exception.APIException;
import net.billforward.exception.AuthenticationException;
import net.billforward.exception.CardException;
import net.billforward.exception.InvalidRequestException;
import net.billforward.model.APIResponse;
import net.billforward.model.BillingEntity;
import net.billforward.model.InsertableEntity;
import net.billforward.model.ResourcePath;

public class CouponCode
extends InsertableEntity<CouponCode> {
    @Expose
    protected String couponCode;
    @Expose
    protected int quantity;
    protected static ResourcePath resourcePath = new ResourcePath("coupons", "coupon", new TypeToken<APIResponse<CouponCode>>(){}.getType());

    public String getCouponCode() {
        return this.couponCode;
    }

    public void setCouponCode(String couponCode) {
        this.couponCode = couponCode;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public void setQuantity(int quantity) {
        this.quantity = quantity;
    }

    public CouponCode(BillForwardClient client_) {
        super(client_);
    }

    public CouponCode() {
    }

    public static CouponCode getByCouponCode(String couponCode) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        CouponCode[] couponCodes = (CouponCode[])CouponCode.getByID((String)couponCode, (ResourcePath)CouponCode.ResourcePath(), (String)"codes");
        if (couponCodes == null || couponCodes.length == 0) {
            return null;
        }
        return couponCodes[0];
    }

    public static CouponCode create(CouponCode couponCodes) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        String extraPath = String.format("%s/codes", couponCodes.couponCode);
        return ((CouponCode[])CouponCode.create((BillingEntity)couponCodes, (ResourcePath)CouponCode.ResourcePath(), (String)extraPath))[0];
    }

    @Override
    protected ResourcePath getResourcePath() {
        return resourcePath;
    }

    protected static ResourcePath ResourcePath() {
        return resourcePath;
    }
}

