/*
 * Decompiled with CFR 0.152.
 */
package net.billforward.model.notifications;

import com.google.gson.JsonParseException;
import com.google.gson.annotations.Expose;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import net.billforward.model.BillingEntity;
import net.billforward.model.ResourcePath;

public class FieldChange
extends BillingEntity {
    @Expose
    String attributeName;
    @Expose
    String previousValue;
    @Expose
    String newValue;
    static SimpleDateFormat historicFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US);
    static SimpleDateFormat dateFormat;

    static {
        historicFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public String getPreviousValue() {
        return this.previousValue;
    }

    public String getNewValue() {
        return this.newValue;
    }

    public Date getPreviousValueAsDate() {
        return this.deserialize(this.previousValue);
    }

    public Date getNewValueAsDate() {
        return this.deserialize(this.newValue);
    }

    public Date deserialize(String dateString) throws JsonParseException {
        Date date = null;
        boolean parsed = false;
        try {
            date = dateFormat.parse(dateString);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        if (!parsed) {
            try {
                date = historicFormat.parse(dateString);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return date;
    }

    @Override
    protected ResourcePath getResourcePath() {
        return null;
    }
}

