/*
 * Decompiled with CFR 0.152.
 */
package net.billforward.model.amendments;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.billforward.BillForwardClient;
import net.billforward.exception.APIConnectionException;
import net.billforward.exception.APIException;
import net.billforward.exception.AuthenticationException;
import net.billforward.exception.CardException;
import net.billforward.exception.InvalidRequestException;
import net.billforward.model.APIResponse;
import net.billforward.model.BillingEntity;
import net.billforward.model.InvoicingType;
import net.billforward.model.ResourcePath;
import net.billforward.model.ValueChangeMode;
import net.billforward.model.amendments.Amendment;
import net.billforward.model.amendments.ComponentChange;

public class PricingComponentValueChangeAmendment
extends Amendment {
    @SerializedName(value="@type")
    @Expose
    protected String amendmentType = Amendment.AmendmentType.PricingComponentValueChangeAmendment.toString();
    @Expose
    ValueChangeMode mode = ValueChangeMode.immediate;
    @Expose
    InvoicingType invoicingType = InvoicingType.Aggregated;
    @Expose
    List<ComponentChange> componentChanges = new ArrayList<ComponentChange>();
    protected static ResourcePath resourcePath = new ResourcePath("amendments", "amendments", new TypeToken<APIResponse<PricingComponentValueChangeAmendment>>(){}.getType());

    public String getAmendmentTypeAsString() {
        return this.amendmentType;
    }

    public Amendment.AmendmentType getAmendmentType() {
        return Amendment.AmendmentType.valueOf(this.amendmentType);
    }

    public ValueChangeMode getMode() {
        return this.mode;
    }

    public void setMode(ValueChangeMode mode) {
        this.mode = mode;
    }

    public InvoicingType getInvoicingType() {
        return this.invoicingType;
    }

    public void setInvoicingType(InvoicingType invoicingType) {
        this.invoicingType = invoicingType;
    }

    public List<ComponentChange> getComponentChanges() {
        return Collections.unmodifiableList(this.componentChanges);
    }

    public ComponentChange addComponentChangeByName(String name, int newValue) {
        ComponentChange change = new ComponentChange();
        change.setName(name);
        change.setNewValue(newValue);
        this.componentChanges.add(change);
        return change;
    }

    public ComponentChange addComponentChangeByComponentID(String componentID, int newValue) {
        ComponentChange change = new ComponentChange();
        change.setLogicalComponentID(componentID);
        change.setNewValue(newValue);
        this.componentChanges.add(change);
        return change;
    }

    public void addComponentChange(ComponentChange change) {
        this.componentChanges.add(change);
    }

    public static PricingComponentValueChangeAmendment create(PricingComponentValueChangeAmendment amendment) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return ((PricingComponentValueChangeAmendment[])PricingComponentValueChangeAmendment.create((BillingEntity)amendment, (ResourcePath)PricingComponentValueChangeAmendment.ResourcePath()))[0];
    }

    public static PricingComponentValueChangeAmendment get(String ID) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        PricingComponentValueChangeAmendment[] amendments = (PricingComponentValueChangeAmendment[])PricingComponentValueChangeAmendment.getByID((String)ID, (ResourcePath)PricingComponentValueChangeAmendment.ResourcePath());
        if (amendments == null || amendments.length == 0) {
            return null;
        }
        return amendments[0];
    }

    public PricingComponentValueChangeAmendment(BillForwardClient client_) {
        super(client_);
    }

    public PricingComponentValueChangeAmendment() {
    }

    @Override
    protected ResourcePath getResourcePath() {
        return resourcePath;
    }

    protected static ResourcePath ResourcePath() {
        return resourcePath;
    }

    public PricingComponentValueChangeAmendment sync() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        PricingComponentValueChangeAmendment amendment = this;
        int maxQuery = 60;
        while (amendment.getState() == Amendment.AmendmentState.Pending) {
            amendment = PricingComponentValueChangeAmendment.get(amendment.getID());
            if (--maxQuery <= 0) break;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
        return amendment;
    }
}

