/*
 * Decompiled with CFR 0.152.
 */
package net.billforward.model.usage;

import com.google.gson.annotations.Expose;
import com.google.gson.reflect.TypeToken;
import java.util.Date;
import java.util.UUID;
import net.billforward.BillForwardClient;
import net.billforward.exception.APIConnectionException;
import net.billforward.exception.APIException;
import net.billforward.exception.AuthenticationException;
import net.billforward.exception.CardException;
import net.billforward.exception.InvalidRequestException;
import net.billforward.model.APIResponse;
import net.billforward.model.BillingEntity;
import net.billforward.model.InsertableEntity;
import net.billforward.model.ResourcePath;
import net.billforward.model.UnitOfMeasure;
import net.billforward.model.usage.UsageState;

public class UsageSession
extends InsertableEntity<UsageSession> {
    @Expose
    protected UsageSession[] usageSessions;
    @Expose
    protected String subscriptionID;
    @Expose
    protected String organizationID;
    @Expose
    protected String sessionID;
    @Expose
    protected String pricingComponentID;
    @Expose
    protected String pricingComponentName;
    @Expose
    protected String uom;
    @Expose
    protected String description;
    @Expose
    protected long sessionix;
    @Expose
    protected Date start;
    @Expose
    protected Date stop;
    @Expose
    protected String state;
    @Expose
    protected String changedBy;
    @Expose
    protected Date created;
    protected static ResourcePath resourcePath = new ResourcePath("usage-sessions", "usageSession", new TypeToken<APIResponse<UsageSession>>(){}.getType());

    public String getSubscriptionID() {
        return this.subscriptionID;
    }

    public void setSubscriptionID(String subscriptionID) {
        this.subscriptionID = subscriptionID;
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public void setSessionID(String sessionID) {
        this.sessionID = sessionID;
    }

    public String getPricingComponentID() {
        return this.pricingComponentID;
    }

    public void setPricingComponentID(String pricingComponentID_) {
        this.pricingComponentID = pricingComponentID_;
    }

    public String getPricingComponentName() {
        return this.pricingComponentName;
    }

    public void setPricingComponenName(String pricingComponentName_) {
        this.pricingComponentName = pricingComponentName_;
    }

    public String getUom() {
        return this.uom;
    }

    public void setUom(String uom) {
        this.uom = uom;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getStart() {
        return this.start;
    }

    public void setStart(Date start) {
        this.start = start;
    }

    public Date getStop() {
        return this.stop;
    }

    public void setStop(Date stop) {
        this.stop = stop;
    }

    public String getOrganizationID() {
        return this.organizationID;
    }

    public long getSessionix() {
        return this.sessionix;
    }

    public String getStateAsString() {
        return this.state;
    }

    public UsageState getState() {
        return UsageState.valueOf(this.state);
    }

    public String getChangedBy() {
        return this.changedBy;
    }

    public Date getCreated() {
        return this.created;
    }

    public static UsageSession startSession(UnitOfMeasure uom, String subscriptionID) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return UsageSession.startSession(uom, subscriptionID, UUID.randomUUID().toString().toUpperCase());
    }

    public static UsageSession startSession(String pricingComponentName, String subscriptionID) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return UsageSession.startSession(pricingComponentName, subscriptionID, UUID.randomUUID().toString().toUpperCase());
    }

    public static UsageSession startSessionByPricingComponentID(String pricingComponentID, String subscriptionID) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return UsageSession.startSessionByPricingComponentID(pricingComponentID, subscriptionID, UUID.randomUUID().toString().toUpperCase());
    }

    public static UsageSession startSessionByPricingComponentID(String pricingComponentID, String subscriptionID, String sessionID) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        BillForwardClient client = BillForwardClient.getClient();
        UsageSession session = new UsageSession(client);
        session.setPricingComponentID(pricingComponentID);
        session.setSubscriptionID(subscriptionID);
        session.setSessionID(sessionID);
        UsageSession[] sessions = UsageSession.startSessions(new UsageSession[]{session});
        return sessions[0];
    }

    public static UsageSession startSession(String pricingComponentName, String subscriptionID, String sessionID) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        BillForwardClient client = BillForwardClient.getClient();
        UsageSession session = new UsageSession(client);
        session.setPricingComponenName(pricingComponentName);
        session.setSubscriptionID(subscriptionID);
        session.setSessionID(sessionID);
        UsageSession[] sessions = UsageSession.startSessions(new UsageSession[]{session});
        return sessions[0];
    }

    public static UsageSession startSession(UnitOfMeasure uom, String subscriptionID, String sessionID) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        BillForwardClient client = BillForwardClient.getClient();
        UsageSession session = new UsageSession(client);
        session.setUom(uom.getName());
        session.setSubscriptionID(subscriptionID);
        session.setSessionID(sessionID);
        UsageSession[] sessions = UsageSession.startSessions(new UsageSession[]{session});
        return sessions[0];
    }

    public static UsageSession[] startSessions(UsageSession[] sessions_) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return (UsageSession[])UsageSession.create((BillingEntity)new UsageSession(sessions_), (ResourcePath)UsageSession.ResourcePath(), (String)"start");
    }

    public static UsageSession[] getSessionsForSubscription(String subscriptionID_) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return (UsageSession[])UsageSession.getByID((String)subscriptionID_, (ResourcePath)UsageSession.ResourcePath());
    }

    public static UsageSession[] getActiveSessionsForSubscription(String subscriptionID_) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return (UsageSession[])UsageSession.getByIDPostPath((String)subscriptionID_, (String)"active", (ResourcePath)UsageSession.ResourcePath());
    }

    public static UsageSession stopSession(UnitOfMeasure uom, String subscriptionID, String sessionID) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        BillForwardClient client = BillForwardClient.getClient();
        UsageSession session = new UsageSession(client);
        session.setUom(uom.getName());
        session.setSubscriptionID(subscriptionID);
        session.setSessionID(sessionID);
        UsageSession[] sessions = UsageSession.stopSession(new UsageSession[]{session});
        return sessions[0];
    }

    public static UsageSession[] stopSession(UsageSession[] sessions_) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        UsageSession tmpUsageSession = new UsageSession(sessions_);
        return (UsageSession[])UsageSession.create((BillingEntity)tmpUsageSession, (ResourcePath)UsageSession.ResourcePath(), (String)"stop");
    }

    public UsageSession stop() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        UsageSession[] sessions = UsageSession.stopSession(new UsageSession[]{this});
        return sessions[0];
    }

    public UsageSession(UsageSession[] sessions) {
        this.usageSessions = sessions;
    }

    public UsageSession(BillForwardClient client_) {
        super(client_);
    }

    protected UsageSession() {
    }

    @Override
    protected ResourcePath getResourcePath() {
        return resourcePath;
    }

    protected static ResourcePath ResourcePath() {
        return resourcePath;
    }
}

