/*
 * Decompiled with CFR 0.152.
 */
package net.billforward.model.tokenization;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import net.billforward.BillForwardClient;
import net.billforward.exception.APIConnectionException;
import net.billforward.exception.APIException;
import net.billforward.exception.AuthenticationException;
import net.billforward.exception.CardException;
import net.billforward.exception.InvalidRequestException;
import net.billforward.model.APIResponse;
import net.billforward.model.PaymentMethod;

public class StripeTokenCapture {
    @SerializedName(value="@type")
    @Expose
    protected String captureType = "StripeAuthCaptureRequest";
    @Expose
    protected String stripeToken;
    @Expose
    protected String cardID;
    @Expose
    protected String accountID;

    public PaymentMethod create() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        String fullRoute;
        BillForwardClient client = BillForwardClient.getClient();
        APIResponse apiResponse = (APIResponse)client.requestUntyped(BillForwardClient.RequestMethod.POST, fullRoute = "tokenization/auth-capture", this, new TypeToken<APIResponse<PaymentMethod>>(){}.getType());
        if (apiResponse.getResults() != null && ((PaymentMethod[])apiResponse.getResults()).length > 0) {
            return ((PaymentMethod[])apiResponse.getResults())[0];
        }
        String message = "Error in capturing token";
        if (apiResponse.getErrorMessage() != null) {
            message = apiResponse.getErrorMessage();
        }
        throw new CardException(message, null, null, null);
    }

    public StripeTokenCapture(String stripeToken_, String cardID_) {
        this(stripeToken_, cardID_, null);
    }

    public StripeTokenCapture(String stripeToken_, String cardID_, String accountID_) {
        this.stripeToken = stripeToken_;
        this.cardID = cardID_;
        this.accountID = accountID_;
    }

    public String getStripeToken() {
        return this.stripeToken;
    }

    public void setStripeToken(String stripeToken) {
        this.stripeToken = stripeToken;
    }

    public String getCardID() {
        return this.cardID;
    }

    public void setCardID(String cardID) {
        this.cardID = cardID;
    }

    public String getAccountID() {
        return this.accountID;
    }

    public void setAccountID(String accountID) {
        this.accountID = accountID;
    }
}

