/*
 * Decompiled with CFR 0.152.
 */
package net.billforward.model.notifications;

import com.google.gson.annotations.Expose;
import java.util.ArrayList;
import java.util.Date;
import net.billforward.BillForwardClient;
import net.billforward.model.BillingEntity;
import net.billforward.model.ResourcePath;
import net.billforward.model.gateways.GatewayTypeMapping;
import net.billforward.model.notifications.AccountNotification;
import net.billforward.model.notifications.AmendmentNotification;
import net.billforward.model.notifications.InvoiceLineNotification;
import net.billforward.model.notifications.InvoiceNotification;
import net.billforward.model.notifications.SubscripitonNotification;
import net.billforward.model.notifications.WebhookNotification;

public class Notification
extends BillingEntity {
    @Expose
    protected String id;
    @Expose
    protected String type;
    @Expose
    protected String domain;
    @Expose
    protected String action;
    @Expose
    protected String organizationID;
    @Expose
    protected String entityID;
    @Expose
    protected String entity;
    @Expose
    protected Date created;

    public String getID() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public NotificationDomain getDomain() {
        return NotificationDomain.valueOf(this.domain);
    }

    public NotificationAction getAction() {
        return NotificationAction.valueOf(this.action);
    }

    public String getOrganizationID() {
        return this.organizationID;
    }

    public String getEntityID() {
        return this.entityID;
    }

    public String getEntity() {
        return this.entity;
    }

    public Date getCreated() {
        return this.created;
    }

    protected Notification() {
    }

    public Notification(BillForwardClient client_) {
        super(client_);
    }

    protected void buildEntity() {
    }

    @Override
    protected ResourcePath getResourcePath() {
        return null;
    }

    public static GatewayTypeMapping[] getTypeMappings() {
        ArrayList<GatewayTypeMapping> typeMappings = new ArrayList<GatewayTypeMapping>();
        typeMappings.add(new GatewayTypeMapping(SubscripitonNotification.class, NotificationDomain.Subscription.toString()));
        typeMappings.add(new GatewayTypeMapping(InvoiceNotification.class, NotificationDomain.Invoice.toString()));
        typeMappings.add(new GatewayTypeMapping(AmendmentNotification.class, NotificationDomain.Amendment.toString()));
        typeMappings.add(new GatewayTypeMapping(InvoiceLineNotification.class, NotificationDomain.InvoiceLine.toString()));
        typeMappings.add(new GatewayTypeMapping(AccountNotification.class, NotificationDomain.Account.toString()));
        typeMappings.add(new GatewayTypeMapping(WebhookNotification.class, NotificationDomain.Webhook.toString()));
        typeMappings.add(new GatewayTypeMapping(Notification.class));
        return typeMappings.toArray(new GatewayTypeMapping[0]);
    }

    public static enum NotificationAction {
        Accept,
        Active,
        AwaitingPayment,
        AwaitingRefund,
        Cancelled,
        Completed,
        Created,
        Error,
        Expired,
        Failed,
        NeedsAmendments,
        Paid,
        Pending,
        Provisioned,
        Refunded,
        Reject,
        Trial,
        Unknown,
        Unpaid,
        Updated,
        Voided;

    }

    public static enum NotificationDomain {
        Notification,
        Organization,
        OrganizationGateway,
        Product,
        User,
        Subscription,
        Profile,
        ProductRatePlan,
        Client,
        Invoice,
        PricingComponentValue,
        Account,
        PricingComponentValueChange,
        PricingComponentTier,
        PricingComponent,
        PricingCalculation,
        CouponDefinition,
        CouponInstance,
        CouponModifier,
        CouponRule,
        CouponBookDefinition,
        CouponBook,
        InvoiceLine,
        Webhook,
        SubscriptionCancellation,
        NotificationSnapshot,
        InvoicePayment,
        Payment,
        PaymentMethod,
        PaymentMethodSubscriptionLink,
        DunningLine,
        CybersourceToken,
        Card,
        Alias,
        PaypalSimplePaymentReconciliation,
        FreePaymentReconciliation,
        LocustworldPaymentReconciliation,
        CouponInstanceExistingValue,
        TaxLine,
        TaxationStrategy,
        TaxationLink,
        Address,
        AmendmentPriceNTime,
        Authority,
        UnitOfMeasure,
        SearchResult,
        Amendment,
        AuditLog,
        Password,
        Username,
        FixedTermDefinition,
        FixedTerm,
        Refund,
        CreditNote,
        Receipt,
        AmendmentCompoundConstituent,
        APIConfiguration,
        StripeToken,
        BraintreeToken,
        BalancedToken,
        AuthorizeNetToken,
        PaypalToken,
        GatewayRevenue,
        Migration,
        AdhocSubscription,
        SubscriptionCharge,
        Verification,
        UsageRoundingStrategies,
        Unknown;

    }
}

