/*
 * Decompiled with CFR 0.152.
 */
package net.billforward.model;

import com.google.gson.annotations.Expose;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.billforward.BillForwardClient;
import net.billforward.exception.APIConnectionException;
import net.billforward.exception.APIException;
import net.billforward.exception.AuthenticationException;
import net.billforward.exception.CardException;
import net.billforward.exception.InvalidRequestException;
import net.billforward.model.APIResponse;
import net.billforward.model.BillingEntity;
import net.billforward.model.InsertableEntity;
import net.billforward.model.QuoteRequestValue;
import net.billforward.model.QuoteType;
import net.billforward.model.ResourcePath;

public class QuoteRequest
extends InsertableEntity<QuoteRequest> {
    @Expose
    protected String product;
    @Expose
    protected String productRatePlan;
    @Expose
    protected String accountID;
    @Expose
    protected String productID;
    @Expose
    protected String subscriptionID;
    @Expose
    protected QuoteType quoteFor;
    @Expose
    protected Boolean prorated;
    @Expose
    protected Boolean free;
    @Expose
    protected List<QuoteRequestValue> quantities = new ArrayList<QuoteRequestValue>();
    @Expose
    protected List<String> couponCodes = new ArrayList<String>();
    @Expose
    protected Date periodStart;
    @Expose
    protected Date periodEnd;
    protected static ResourcePath resourcePath = new ResourcePath("quotes", "quotes", new TypeToken<APIResponse<QuoteRequest>>(){}.getType());

    public void addQuantity(String pricingComponent, int quantity) {
        QuoteRequestValue comp = new QuoteRequestValue();
        comp.pricingComponent = pricingComponent;
        comp.quantity = quantity;
        this.quantities.add(comp);
    }

    public void addCoupon(String coupon) {
        this.couponCodes.add(coupon);
    }

    public static QuoteRequest create(QuoteRequest quoteRequest) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return ((QuoteRequest[])QuoteRequest.create((BillingEntity)quoteRequest, (ResourcePath)QuoteRequest.ResourcePath()))[0];
    }

    public QuoteRequest() {
    }

    public QuoteRequest(BillForwardClient client_) {
        super(client_);
    }

    @Override
    protected ResourcePath getResourcePath() {
        return resourcePath;
    }

    public static ResourcePath ResourcePath() {
        return resourcePath;
    }
}

