/*
 * Decompiled with CFR 0.152.
 */
package net.billforward.model;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.lang.reflect.Field;
import net.billforward.BillForwardClient;
import net.billforward.exception.APIConnectionException;
import net.billforward.exception.APIException;
import net.billforward.exception.AuthenticationException;
import net.billforward.exception.CardException;
import net.billforward.exception.InvalidRequestException;
import net.billforward.model.APIResponse;
import net.billforward.model.ResourcePath;

public abstract class BillingEntity {
    protected BillForwardClient m_client;
    public static final Gson PRETTY_PRINT_GSON = new GsonBuilder().setPrettyPrinting().setDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").excludeFieldsWithoutExposeAnnotation().setFieldNamingPolicy(FieldNamingPolicy.IDENTITY).create();

    public BillForwardClient getClient() {
        return this.m_client;
    }

    public void setClient(BillForwardClient client_) {
        this.m_client = client_;
    }

    public BillingEntity() {
    }

    public BillingEntity(BillForwardClient client_) {
        this.m_client = client_;
    }

    protected static <TStaticEntityType extends BillingEntity> TStaticEntityType[] getByIDPostPath(String ID, String postPath, ResourcePath path) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        String endPoint;
        String apiRoute;
        String fullRoute;
        BillForwardClient client = BillForwardClient.getClient();
        APIResponse<Object> resp = client.request(BillForwardClient.RequestMethod.GET, fullRoute = String.format("%s%s", apiRoute = path.getPath(), endPoint = String.format("/%s/%s", ID, postPath)), null, path.getResponseType());
        if (resp == null || resp.results == null || ((BillingEntity[])resp.results).length < 1) {
            return null;
        }
        BillingEntity[] billingEntityArray = (BillingEntity[])resp.results;
        int n = billingEntityArray.length;
        int n2 = 0;
        while (n2 < n) {
            BillingEntity res = billingEntityArray[n2];
            res.setClient(client);
            ++n2;
        }
        return (BillingEntity[])resp.results;
    }

    protected static <TStaticEntityType extends BillingEntity> TStaticEntityType[] getByID(String ID, String prePath, ResourcePath path) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return BillingEntity.getByID((String)ID, (String)prePath, (ResourcePath)path, null);
    }

    protected static <TStaticEntityType extends BillingEntity> TStaticEntityType[] getByID(String ID, String prePath, ResourcePath path, String postfixPath) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        APIResponse<Object> resp;
        BillForwardClient client = BillForwardClient.getClient();
        String apiRoute = path.getPath();
        String endPoint = String.format("/%s/%s", prePath, ID);
        String fullRoute = String.format("%s%s", apiRoute, endPoint);
        if (postfixPath != null) {
            fullRoute = String.format("%s/%s", fullRoute, postfixPath);
        }
        if ((resp = client.request(BillForwardClient.RequestMethod.GET, fullRoute, null, path.getResponseType())) == null || resp.results == null || ((BillingEntity[])resp.results).length < 1) {
            return null;
        }
        BillingEntity[] billingEntityArray = (BillingEntity[])resp.results;
        int n = billingEntityArray.length;
        int n2 = 0;
        while (n2 < n) {
            BillingEntity res = billingEntityArray[n2];
            res.setClient(client);
            ++n2;
        }
        return (BillingEntity[])resp.results;
    }

    protected static <TStaticEntityType extends BillingEntity> TStaticEntityType[] getByID(String ID, ResourcePath path) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return BillingEntity.getByID((String)ID, (ResourcePath)path, null);
    }

    protected static <TStaticEntityType extends BillingEntity> TStaticEntityType[] getByID(String ID, ResourcePath path, String postfixPath) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        APIResponse<Object> resp;
        BillForwardClient client = BillForwardClient.getClient();
        String apiRoute = path.getPath();
        String endPoint = String.format("/%s", ID);
        String fullRoute = String.format("%s%s", apiRoute, endPoint);
        if (postfixPath != null) {
            fullRoute = String.format("%s/%s", fullRoute, postfixPath);
        }
        if ((resp = client.request(BillForwardClient.RequestMethod.GET, fullRoute, null, path.getResponseType())) == null || resp.results == null || ((BillingEntity[])resp.results).length < 1) {
            return null;
        }
        BillingEntity[] billingEntityArray = (BillingEntity[])resp.results;
        int n = billingEntityArray.length;
        int n2 = 0;
        while (n2 < n) {
            BillingEntity res = billingEntityArray[n2];
            res.setClient(client);
            ++n2;
        }
        return (BillingEntity[])resp.results;
    }

    protected static <TStaticEntityType extends BillingEntity> TStaticEntityType[] getAll(ResourcePath path) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        BillingEntity[] res;
        String apiRoute;
        String fullRoute;
        BillForwardClient client = BillForwardClient.getClient();
        APIResponse<Object> resp = client.request(BillForwardClient.RequestMethod.GET, fullRoute = String.format("%s", apiRoute = path.getPath()), null, path.getResponseType());
        if (resp == null || resp.results == null || ((BillingEntity[])resp.results).length < 1) {
            return null;
        }
        BillingEntity[] billingEntityArray = res = (BillingEntity[])resp.results;
        int n = res.length;
        int n2 = 0;
        while (n2 < n) {
            BillingEntity ntt = billingEntityArray[n2];
            ntt.setClient(client);
            ++n2;
        }
        return res;
    }

    protected static <TStaticEntityType extends BillingEntity> TStaticEntityType[] getAll(ResourcePath path, String explicitPath) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        BillingEntity[] res;
        BillForwardClient client = BillForwardClient.getClient();
        APIResponse<Object> resp = client.request(BillForwardClient.RequestMethod.GET, explicitPath, null, path.getResponseType());
        if (resp == null || resp.results == null || ((BillingEntity[])resp.results).length < 1) {
            return null;
        }
        BillingEntity[] billingEntityArray = res = (BillingEntity[])resp.results;
        int n = res.length;
        int n2 = 0;
        while (n2 < n) {
            BillingEntity ntt = billingEntityArray[n2];
            ntt.setClient(client);
            ++n2;
        }
        return res;
    }

    public String toString() {
        return String.format("#%s@%s id=%s# JSON: %s", this.getClass().getName(), System.identityHashCode(this), this.getIDString(), PRETTY_PRINT_GSON.toJson((Object)this));
    }

    private Object getIDString() {
        try {
            Field idField = this.getClass().getDeclaredField("id");
            return idField.get(this);
        }
        catch (SecurityException e) {
            return "";
        }
        catch (NoSuchFieldException e) {
            return "";
        }
        catch (IllegalArgumentException e) {
            return "";
        }
        catch (IllegalAccessException e) {
            return "";
        }
    }

    protected abstract ResourcePath getResourcePath();
}

