/*
 * Decompiled with CFR 0.152.
 */
package net.billforward.model;

import com.google.gson.annotations.Expose;
import com.google.gson.reflect.TypeToken;
import java.util.Date;
import net.billforward.BillForwardClient;
import net.billforward.exception.APIConnectionException;
import net.billforward.exception.APIException;
import net.billforward.exception.AuthenticationException;
import net.billforward.exception.CardException;
import net.billforward.exception.InvalidRequestException;
import net.billforward.model.APIResponse;
import net.billforward.model.BillingEntity;
import net.billforward.model.MutableEntity;
import net.billforward.model.PaymentMethod;
import net.billforward.model.Profile;
import net.billforward.model.ResourcePath;

public class Account
extends MutableEntity<Account> {
    @Expose
    protected String id;
    @Expose
    protected String organizationID;
    @Expose
    protected String userID;
    @Expose
    protected int successfulSubscriptions;
    @Expose
    protected boolean deleted;
    @Expose
    protected Date created;
    @Expose
    protected Date updated;
    @Expose
    protected String changedBy;
    @Expose
    protected Profile profile;
    @Expose
    protected PaymentMethod[] paymentMethods;
    protected static ResourcePath resourcePath = new ResourcePath("accounts", "account", new TypeToken<APIResponse<Account>>(){}.getType());

    public String getID() {
        return this.id;
    }

    public String getOrganizationID() {
        return this.organizationID;
    }

    public String getUserID() {
        return this.userID;
    }

    public void setUserID(String userID) {
        this.userID = userID;
    }

    public int getSuccessfulSubscriptions() {
        return this.successfulSubscriptions;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public Date getCreated() {
        return this.created;
    }

    public Date getUpdated() {
        return this.updated;
    }

    public String getChangedBy() {
        return this.changedBy;
    }

    public Profile getProfile() {
        if (this.profile == null) {
            this.profile = new Profile();
        }
        if (this.profile.m_client == null) {
            this.profile.setClient(this.m_client);
        }
        return this.profile;
    }

    public void setProfile(Profile profile_) {
        this.profile = profile_;
    }

    public PaymentMethod[] getPaymentMethods() {
        return this.paymentMethods;
    }

    public static Account create(Account account) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return ((Account[])Account.create((BillingEntity)account, (ResourcePath)Account.ResourcePath()))[0];
    }

    public static Account getByID(String ID) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        Account[] accs = (Account[])Account.getByID((String)ID, (ResourcePath)Account.ResourcePath());
        if (accs == null || accs.length == 0) {
            return null;
        }
        return accs[0];
    }

    public static Account[] getAll() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return (Account[])Account.getAll((ResourcePath)Account.ResourcePath());
    }

    public Account(BillForwardClient client_) {
        super(client_);
    }

    public Account() {
    }

    @Override
    protected ResourcePath getResourcePath() {
        return resourcePath;
    }

    protected static ResourcePath ResourcePath() {
        return resourcePath;
    }
}

