/*
 * Decompiled with CFR 0.152.
 */
package net.billforward.model.usage;

import com.google.gson.annotations.Expose;
import com.google.gson.reflect.TypeToken;
import java.util.Date;
import net.billforward.BillForwardClient;
import net.billforward.exception.APIConnectionException;
import net.billforward.exception.APIException;
import net.billforward.exception.AuthenticationException;
import net.billforward.exception.CardException;
import net.billforward.exception.InvalidRequestException;
import net.billforward.model.APIResponse;
import net.billforward.model.BillingEntity;
import net.billforward.model.ResourcePath;
import net.billforward.model.usage.UsageType;

public class Usage
extends BillingEntity {
    @Expose
    protected String id;
    @Expose
    protected String organizationID;
    @Expose
    protected String sessiondID;
    @Expose
    protected String subscriptionID;
    @Expose
    protected String uom;
    @Expose
    protected int usagePeriod;
    @Expose
    protected long usageDuration;
    @Expose
    protected String usageType;
    @Expose
    protected long usageValue;
    @Expose
    protected Date start;
    @Expose
    protected Date stop;
    @Expose
    protected Date updated;
    protected static ResourcePath resourcePath = new ResourcePath("usage", "usage", new TypeToken<APIResponse<Usage>>(){}.getType());

    public String getID() {
        return this.id;
    }

    public String getOrganizationID() {
        return this.organizationID;
    }

    public String getSessiondID() {
        return this.sessiondID;
    }

    public String getSubscriptionID() {
        return this.subscriptionID;
    }

    public String getUom() {
        return this.uom;
    }

    public int getUsagePeriod() {
        return this.usagePeriod;
    }

    public long getUsageDuration() {
        return this.usageDuration;
    }

    public UsageType getUsageType() {
        return UsageType.valueOf(this.usageType);
    }

    public String getUsageTypeAsString() {
        return this.usageType;
    }

    public long getUsageValue() {
        return this.usageValue;
    }

    public Date getStart() {
        return this.start;
    }

    public Date getStop() {
        return this.stop;
    }

    public Date getUpdated() {
        return this.updated;
    }

    public static Usage[] getUsageForSubscription(String subscriptionID_) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return (Usage[])Usage.getByID((String)subscriptionID_, (ResourcePath)Usage.ResourcePath());
    }

    public static Usage[] getUsageForSubscriptionPeriod(String subscriptionID_, int period_) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return (Usage[])Usage.getByIDPostPath((String)subscriptionID_, (String)Integer.valueOf(period_).toString(), (ResourcePath)Usage.ResourcePath());
    }

    public Usage(BillForwardClient client_) {
        super(client_);
    }

    protected Usage() {
    }

    protected ResourcePath getResourcePath() {
        return resourcePath;
    }

    protected static ResourcePath ResourcePath() {
        return resourcePath;
    }
}

