/*
 * Decompiled with CFR 0.152.
 */
package net.billforward.model;

import com.google.gson.annotations.Expose;
import com.google.gson.reflect.TypeToken;
import java.util.Date;
import net.billforward.BillForwardClient;
import net.billforward.exception.APIConnectionException;
import net.billforward.exception.APIException;
import net.billforward.exception.AuthenticationException;
import net.billforward.exception.CardException;
import net.billforward.exception.InvalidRequestException;
import net.billforward.model.APIResponse;
import net.billforward.model.BillingEntity;
import net.billforward.model.CardType;
import net.billforward.model.MutableEntity;
import net.billforward.model.PaymentGateway;
import net.billforward.model.ResourcePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PaymentMethod
extends MutableEntity<PaymentMethod> {
    @Expose
    protected String id;
    @Expose
    protected String accountID;
    @Expose
    protected String organizationID;
    @Expose
    protected String name;
    @Expose
    protected String description;
    @Expose
    protected String cardHolderName;
    @Expose
    protected String expiryDate;
    @Expose
    protected String cardType;
    @Expose
    protected String gateway;
    @Expose
    protected String linkID = "";
    @Expose
    protected int priority;
    @Expose
    protected Boolean reusable;
    @Expose
    protected Boolean deleted;
    @Expose
    protected Date updated;
    @Expose
    protected String changedBy;
    @Expose
    protected Date created;
    protected static ResourcePath resourcePath = new ResourcePath("payment-methods", "paymentMethod", new TypeToken<APIResponse<PaymentMethod>>(){}.getType());

    public String getID() {
        return this.id;
    }

    public String getAccountID() {
        return this.accountID;
    }

    public void setAccountID(String accountID) {
        this.accountID = accountID;
    }

    public String getOrganizationID() {
        return this.organizationID;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCardHolderName() {
        return this.cardHolderName;
    }

    public void setCardHolderName(String cardHolderName) {
        this.cardHolderName = cardHolderName;
    }

    public String getExpiryDate() {
        return this.expiryDate;
    }

    public void setExpiryDate(String expiryDate) {
        this.expiryDate = expiryDate;
    }

    public String getCardTypeAsString() {
        return this.cardType;
    }

    public CardType getCardType() {
        return CardType.valueOf(this.cardType);
    }

    public void setCardType(CardType cardType) {
        this.cardType = cardType.toString();
    }

    public String getPaymentGatewayAsString() {
        return this.gateway;
    }

    public PaymentGateway getGateway() {
        return PaymentGateway.valueOf(this.gateway);
    }

    public void setGateway(PaymentGateway cardType) {
        this.gateway = cardType.toString();
    }

    public String getLinkID() {
        return this.linkID;
    }

    public void setLinkID(String linkID) {
        this.linkID = linkID;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public Boolean getReusable() {
        return this.reusable;
    }

    public void setReusable(Boolean reusable) {
        this.reusable = reusable;
    }

    public Boolean getDeleted() {
        return this.deleted;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public Date getUpdated() {
        return this.updated;
    }

    public String getChangedBy() {
        return this.changedBy;
    }

    public Date getCreated() {
        return this.created;
    }

    public static PaymentMethod create(PaymentMethod paymentMethod) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return ((PaymentMethod[])PaymentMethod.create((BillingEntity)paymentMethod, (ResourcePath)PaymentMethod.ResourcePath()))[0];
    }

    public static PaymentMethod getByID(String ID) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        PaymentMethod[] paymentMethods = (PaymentMethod[])PaymentMethod.getByID((String)ID, (ResourcePath)PaymentMethod.ResourcePath());
        return paymentMethods[0];
    }

    public PaymentMethod(BillForwardClient client_) {
        super(client_);
    }

    public PaymentMethod() {
    }

    @Override
    public ResourcePath getResourcePath() {
        return resourcePath;
    }

    public static ResourcePath ResourcePath() {
        return resourcePath;
    }
}

