/*
 * Decompiled with CFR 0.152.
 */
package net.billforward;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.Expose;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.net.URLStreamHandler;
import java.security.Security;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import java.util.TimeZone;
import net.billforward.exception.APIConnectionException;
import net.billforward.exception.APIException;
import net.billforward.exception.AuthenticationException;
import net.billforward.exception.CardException;
import net.billforward.exception.InvalidRequestException;
import net.billforward.gson.typeadapters.RuntimeTypeAdapterFactory;
import net.billforward.model.APIResponse;
import net.billforward.model.amendments.Amendment;
import net.billforward.model.gateways.APIConfiguration;
import net.billforward.model.gateways.GatewayTypeMapping;
import net.billforward.model.notifications.Notification;
import net.billforward.net.BillForwardResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BillForwardClient {
    public String apiKey;
    public String apiUrl;
    public static final String CHARSET = "UTF-8";
    private static final String DNS_CACHE_TTL_PROPERTY_NAME = "networkaddress.cache.ttl";
    private boolean verifySSL = false;
    protected static BillForwardClient defaultClient;
    public static Gson GSON;
    private static final String CUSTOM_URL_STREAM_HANDLER_PROPERTY_NAME = "net.billforward.net.customURLStreamHandler";

    static {
        GatewayTypeMapping[] mappings;
        RuntimeTypeAdapterFactory<APIConfiguration> apiConfigAdapter = RuntimeTypeAdapterFactory.of(APIConfiguration.class, "@type");
        GatewayTypeMapping[] gatewayTypeMappingArray = mappings = APIConfiguration.getTypeMappings();
        int n = mappings.length;
        int n2 = 0;
        while (n2 < n) {
            GatewayTypeMapping mapping = gatewayTypeMappingArray[n2];
            apiConfigAdapter.registerSubtype(mapping.getApiType(), mapping.getName());
            ++n2;
        }
        RuntimeTypeAdapterFactory<Amendment> amendmentConfigAdapter = RuntimeTypeAdapterFactory.of(Amendment.class, "@type");
        GatewayTypeMapping[] gatewayTypeMappingArray2 = mappings = Amendment.getTypeMappings();
        int n3 = mappings.length;
        n = 0;
        while (n < n3) {
            GatewayTypeMapping mapping = gatewayTypeMappingArray2[n];
            amendmentConfigAdapter.registerSubtype(mapping.getApiType(), mapping.getName());
            ++n;
        }
        RuntimeTypeAdapterFactory<Notification> notificationConfigAdapter = RuntimeTypeAdapterFactory.of(Notification.class, "domain");
        GatewayTypeMapping[] gatewayTypeMappingArray3 = mappings = Notification.getTypeMappings();
        int n4 = mappings.length;
        n3 = 0;
        while (n3 < n4) {
            GatewayTypeMapping mapping = gatewayTypeMappingArray3[n3];
            if (mapping.getName() == null) {
                notificationConfigAdapter.registerSubtype(mapping.getApiType(), "default_value_mapping");
            } else {
                notificationConfigAdapter.registerSubtype(mapping.getApiType(), mapping.getName());
            }
            ++n3;
        }
        GSON = new GsonBuilder().registerTypeAdapter(Date.class, (Object)new DateTypeAdapter()).excludeFieldsWithoutExposeAnnotation().registerTypeAdapterFactory(apiConfigAdapter).registerTypeAdapterFactory(amendmentConfigAdapter).registerTypeAdapterFactory(notificationConfigAdapter).setFieldNamingPolicy(FieldNamingPolicy.IDENTITY).create();
    }

    public static BillForwardClient getClient() throws APIException {
        if (defaultClient == null) {
            throw new APIException("Please set a valid BillForward client using BillForwardClient.makeDefaultClient(...) before calling methods", null);
        }
        return defaultClient;
    }

    public static void setDefaultClient(BillForwardClient client_) {
        defaultClient = client_;
    }

    public static BillForwardClient makeDefaultClient(String apiKey_, String apiUrl_) {
        defaultClient = new BillForwardClient();
        defaultClient.setAPIKey(apiKey_);
        defaultClient.setAPIUrl(apiUrl_);
        return defaultClient;
    }

    public void setVerifySSL(boolean verify) {
        this.verifySSL = verify;
    }

    public boolean getVerifySSL() {
        return this.verifySSL;
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    private static String urlEncode(String str) throws UnsupportedEncodingException {
        if (str == null) {
            return null;
        }
        return URLEncoder.encode(str, CHARSET);
    }

    private Map<String, String> getHeaders(String apiKey) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept-Charset", CHARSET);
        headers.put("User-Agent", String.format("BillForward/JavaBindings/%s", this.apiUrl));
        headers.put("Authorization", String.format("Bearer %s", apiKey));
        String[] propertyNames = new String[]{"os.name", "os.version", "os.arch", "java.version", "java.vendor", "java.vm.version", "java.vm.vendor"};
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        String[] stringArray = propertyNames;
        int n = propertyNames.length;
        int n2 = 0;
        while (n2 < n) {
            String propertyName = stringArray[n2];
            propertyMap.put(propertyName, System.getProperty(propertyName));
            ++n2;
        }
        propertyMap.put("lang", "Java");
        propertyMap.put("publisher", "BillForward");
        headers.put("X-BillForward-Client-User-Agent", GSON.toJson(propertyMap));
        return headers;
    }

    private HttpURLConnection createBillForwardConnection(String url, String apiKey) throws IOException {
        URL BillForwardURL = null;
        String customURLStreamHandlerClassName = System.getProperty(CUSTOM_URL_STREAM_HANDLER_PROPERTY_NAME, null);
        if (customURLStreamHandlerClassName != null) {
            try {
                Class<?> clazz = Class.forName(customURLStreamHandlerClassName);
                Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                URLStreamHandler customHandler = (URLStreamHandler)constructor.newInstance(new Object[0]);
                BillForwardURL = new URL(null, url, customHandler);
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e);
            }
            catch (SecurityException e) {
                throw new IOException(e);
            }
            catch (NoSuchMethodException e) {
                throw new IOException(e);
            }
            catch (IllegalArgumentException e) {
                throw new IOException(e);
            }
            catch (InstantiationException e) {
                throw new IOException(e);
            }
            catch (IllegalAccessException e) {
                throw new IOException(e);
            }
            catch (InvocationTargetException e) {
                throw new IOException(e);
            }
        } else {
            BillForwardURL = new URL(url);
        }
        HttpURLConnection conn = (HttpURLConnection)BillForwardURL.openConnection();
        conn.setConnectTimeout(30000);
        conn.setReadTimeout(80000);
        conn.setUseCaches(false);
        for (Map.Entry<String, String> header : this.getHeaders(apiKey).entrySet()) {
            conn.setRequestProperty(header.getKey(), header.getValue());
        }
        return conn;
    }

    private static String formatURL(String url, String query) {
        if (query == null || query.isEmpty()) {
            return url;
        }
        String separator = url.contains("?") ? "&" : "?";
        return String.format("%s%s%s", url, separator, query);
    }

    private HttpURLConnection createGetConnection(String url, String query, String apiKey) throws IOException, APIConnectionException {
        String getURL = BillForwardClient.formatURL(url, query);
        HttpURLConnection conn = this.createBillForwardConnection(getURL, apiKey);
        conn.setRequestMethod("GET");
        return conn;
    }

    private HttpURLConnection createPostConnection(String url, String query, String apiKey) throws IOException, APIConnectionException {
        HttpURLConnection conn = this.createBillForwardConnection(url, apiKey);
        conn.setDoOutput(true);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", String.format("application/json;charset=%s", CHARSET));
        OutputStream output = null;
        try {
            output = conn.getOutputStream();
            output.write(query.getBytes(CHARSET));
        }
        finally {
            if (output != null) {
                output.close();
            }
        }
        return conn;
    }

    private HttpURLConnection createPutConnection(String url, String query, String apiKey) throws IOException, APIConnectionException {
        HttpURLConnection conn = this.createBillForwardConnection(url, apiKey);
        conn.setDoOutput(true);
        conn.setRequestMethod("PUT");
        conn.setRequestProperty("Content-Type", String.format("application/json;charset=%s", CHARSET));
        OutputStream output = null;
        try {
            output = conn.getOutputStream();
            output.write(query.getBytes(CHARSET));
        }
        finally {
            if (output != null) {
                output.close();
            }
        }
        return conn;
    }

    private HttpURLConnection createDeleteConnection(String url, String query, String apiKey) throws IOException, APIConnectionException {
        String deleteUrl = url;
        HttpURLConnection conn = this.createBillForwardConnection(deleteUrl, apiKey);
        conn.setRequestMethod("DELETE");
        return conn;
    }

    private static String getResponseBody(InputStream responseStream) throws IOException {
        String rBody = new Scanner(responseStream, CHARSET).useDelimiter("\\A").next();
        responseStream.close();
        return rBody;
    }

    private BillForwardResponse makeURLConnectionRequest(RequestMethod method, String url, String query, String apiKey) throws APIConnectionException {
        HttpURLConnection conn = null;
        try {
            switch (method) {
                case GET: {
                    conn = this.createGetConnection(url, query, apiKey);
                    break;
                }
                case POST: {
                    conn = this.createPostConnection(url, query, apiKey);
                    break;
                }
                case PUT: {
                    conn = this.createPutConnection(url, query, apiKey);
                    break;
                }
                case DELETE: {
                    conn = this.createDeleteConnection(url, query, apiKey);
                    break;
                }
                default: {
                    throw new APIConnectionException(String.format("Unrecognized HTTP method %s. This indicates a bug in the BillForward bindings. Please contact support@BillForward.com for assistance.", new Object[]{method}));
                }
            }
            int rCode = conn.getResponseCode();
            String rBody = null;
            rBody = rCode >= 200 && rCode < 300 ? BillForwardClient.getResponseBody(conn.getInputStream()) : BillForwardClient.getResponseBody(conn.getErrorStream());
            Map<String, List<String>> headers = conn.getHeaderFields();
            BillForwardResponse billForwardResponse = new BillForwardResponse(rCode, rBody, headers);
            return billForwardResponse;
        }
        catch (IOException e) {
            throw new APIConnectionException(String.format("IOException during API request to BillForward (%s): %s Please check your internet connection and try again. If this problem persists,you should check BillForward's service status at https://twitter.com/BillForwardstatus, or let us know at support@BillForward.com.", this.getApiUrl(), e.getMessage()), e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    public <TRequest, TResponse> TResponse requestUntyped(RequestMethod method, String url, TRequest obj, Type responseType) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        url = String.format("%s/%s", this.apiUrl, url);
        String originalDNSCacheTTL = null;
        Boolean allowedToSetTTL = true;
        try {
            originalDNSCacheTTL = Security.getProperty(DNS_CACHE_TTL_PROPERTY_NAME);
            Security.setProperty(DNS_CACHE_TTL_PROPERTY_NAME, "0");
        }
        catch (SecurityException se) {
            allowedToSetTTL = false;
        }
        try {
            TResponse TResponse = this._requestUntyped(responseType, method, url, obj, this.apiKey);
            return TResponse;
        }
        finally {
            if (allowedToSetTTL.booleanValue()) {
                if (originalDNSCacheTTL == null) {
                    Security.setProperty(DNS_CACHE_TTL_PROPERTY_NAME, "-1");
                } else {
                    Security.setProperty(DNS_CACHE_TTL_PROPERTY_NAME, originalDNSCacheTTL);
                }
            }
        }
    }

    public <T> APIResponse<T> request(RequestMethod method, String url, T obj, Type responseType) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        url = String.format("%s/%s", this.apiUrl, url);
        String originalDNSCacheTTL = null;
        Boolean allowedToSetTTL = true;
        try {
            originalDNSCacheTTL = Security.getProperty(DNS_CACHE_TTL_PROPERTY_NAME);
            Security.setProperty(DNS_CACHE_TTL_PROPERTY_NAME, "0");
        }
        catch (SecurityException se) {
            allowedToSetTTL = false;
        }
        try {
            APIResponse<T> aPIResponse = this._request(responseType, method, url, obj, this.apiKey);
            return aPIResponse;
        }
        finally {
            if (allowedToSetTTL.booleanValue()) {
                if (originalDNSCacheTTL == null) {
                    Security.setProperty(DNS_CACHE_TTL_PROPERTY_NAME, "-1");
                } else {
                    Security.setProperty(DNS_CACHE_TTL_PROPERTY_NAME, originalDNSCacheTTL);
                }
            }
        }
    }

    protected <TRequest, TResponse> TResponse _requestUntyped(Type responseType, RequestMethod method, String url, TRequest obj, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        if (!(apiKey != null && apiKey.length() != 0 || apiKey != null && apiKey.length() != 0)) {
            throw new AuthenticationException("No API key provided. (HINT: set your API key using 'BillForward.apiKey = <API-KEY>'. You can generate API keys from the BillForward web interface. See https://BillForward.com/api for details or email support@BillForward.com if you have questions.");
        }
        String query = "";
        if (obj != null) {
            query = GSON.toJson(obj);
        }
        BillForwardResponse response = this.makeURLConnectionRequest(method, url, query, apiKey);
        int rCode = response.getResponseCode();
        String rBody = response.getResponseBody();
        if (rCode < 200 || rCode >= 300) {
            this.handleAPIError(rBody, rCode);
        }
        Object acc = GSON.fromJson(rBody, responseType);
        return (TResponse)acc;
    }

    protected <T> APIResponse<T> _request(Type responseType, RequestMethod method, String url, T obj, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        if (!(apiKey != null && apiKey.length() != 0 || apiKey != null && apiKey.length() != 0)) {
            throw new AuthenticationException("No API key provided. (HINT: set your API key using 'BillForward.apiKey = <API-KEY>'. You can generate API keys from the BillForward web interface. See https://BillForward.com/api for details or email support@BillForward.com if you have questions.");
        }
        String query = "";
        if (obj != null) {
            query = GSON.toJson(obj);
        }
        BillForwardResponse response = this.makeURLConnectionRequest(method, url, query, apiKey);
        int rCode = response.getResponseCode();
        String rBody = response.getResponseBody();
        if (rCode < 200 || rCode >= 300) {
            this.handleAPIError(rBody, rCode);
        }
        APIResponse acc = (APIResponse)GSON.fromJson(rBody, responseType);
        return acc;
    }

    private void handleAPIError(String rBody, int rCode) throws InvalidRequestException, AuthenticationException, CardException, APIException {
        Error error = (Error)GSON.fromJson(rBody, Error.class);
        switch (rCode) {
            case 400: {
                throw new InvalidRequestException(error.errorMessage, error.getErrorParameters(), null);
            }
            case 404: {
                throw new InvalidRequestException(error.errorMessage, error.getErrorParameters(), null);
            }
            case 401: {
                throw new AuthenticationException(error.errorMessage);
            }
            case 402: {
                throw new CardException(error.errorMessage, error.getErrorParameters(), error.getErrorParameters(), null);
            }
        }
        throw new APIException(error.getErrorParameters(), null);
    }

    public void setAPIKey(String apiKey_) {
        this.apiKey = apiKey_;
    }

    public void setAPIUrl(String apiUrl_) {
        this.apiUrl = apiUrl_;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DateTypeAdapter
    implements JsonSerializer<Date>,
    JsonDeserializer<Date> {
        private final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);

        private DateTypeAdapter() {
            this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        }

        public Date deserialize(JsonElement jsonElement, Type arg1, JsonDeserializationContext arg2) throws JsonParseException {
            Date date = null;
            try {
                date = this.dateFormat.parse(jsonElement.getAsString());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            return date;
        }

        public JsonElement serialize(Date date, Type arg1, JsonSerializationContext arg2) {
            String dateFormatAsString = this.dateFormat.format(date);
            return new JsonPrimitive(dateFormatAsString);
        }
    }

    private class Error {
        @Expose
        String errorType;
        @Expose
        String errorMessage;
        @Expose
        String[] errorParameters;

        private Error() {
        }

        public String getErrorParameters() {
            String errorParams = "";
            if (this.errorParameters == null) {
                return errorParams;
            }
            String[] stringArray = this.errorParameters;
            int n = this.errorParameters.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                errorParams = String.valueOf(errorParams) + s + " ";
                ++n2;
            }
            return errorParams;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RequestMethod {
        GET,
        POST,
        DELETE,
        PUT;

    }
}

