/*
 * Decompiled with CFR 0.152.
 */
package net.billforward.model;

import com.google.gson.annotations.Expose;
import com.google.gson.reflect.TypeToken;
import java.util.Date;
import net.billforward.BillForwardClient;
import net.billforward.exception.APIConnectionException;
import net.billforward.exception.APIException;
import net.billforward.exception.AuthenticationException;
import net.billforward.exception.CardException;
import net.billforward.exception.InvalidRequestException;
import net.billforward.model.APIResponse;
import net.billforward.model.BillingEntity;
import net.billforward.model.MutableEntity;
import net.billforward.model.ResourcePath;
import net.billforward.model.StringEnum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Product
extends MutableEntity<Product> {
    @Expose
    protected String id;
    @Expose
    protected String accountID;
    @Expose
    protected String organizationID;
    @Expose
    protected String name;
    @Expose
    protected String description;
    @Expose
    protected String durationPeriod;
    @Expose
    protected int duration;
    @Expose
    protected int trial;
    @Expose
    protected String trialPeriod;
    @Expose
    protected String productType;
    @Expose
    protected String state = "prod";
    @Expose
    protected Boolean deleted = false;
    @Expose
    protected Date startDate;
    @Expose
    protected Date updated;
    @Expose
    protected String changedBy;
    @Expose
    protected Date created;
    protected static ResourcePath resourcePath = new ResourcePath("products", "product", new TypeToken<APIResponse<Product>>(){}.getType());

    public String getID() {
        return this.id;
    }

    public String getAccountID() {
        return this.accountID;
    }

    public void setAccountID(String accountID) {
        this.accountID = accountID;
    }

    public String getOrganizationID() {
        return this.organizationID;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ProductPeriod getDurationPeriod() {
        return ProductPeriod.valueOf(this.durationPeriod);
    }

    public String getDurationPeriodAsString() {
        return this.durationPeriod;
    }

    public void setDurationPeriod(ProductPeriod durationPeriod) {
        this.durationPeriod = durationPeriod.toString();
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public int getTrial() {
        return this.trial;
    }

    public void setTrial(int trial) {
        this.trial = trial;
    }

    public String getTrialPeriod() {
        return this.trialPeriod;
    }

    public void setTrialPeriod(String trialPeriod) {
        this.trialPeriod = trialPeriod;
    }

    public ProductType getProductType() {
        return ProductType.valueOf(this.productType);
    }

    public String getProductTypeAsString() {
        return this.productType;
    }

    public void setProductType(ProductType productType) {
        this.productType = productType.name();
    }

    public String getState() {
        return this.state;
    }

    public Boolean getDeleted() {
        return this.deleted;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getUpdated() {
        return this.updated;
    }

    public String getChangedBy() {
        return this.changedBy;
    }

    public Date getCreated() {
        return this.created;
    }

    public Product(BillForwardClient client_) {
        super(client_);
    }

    public Product() {
    }

    public Product retire() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return (Product)Product.retire(this.getID(), Product.ResourcePath());
    }

    public static Product create(Product product) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return ((Product[])Product.create((BillingEntity)product, (ResourcePath)Product.ResourcePath()))[0];
    }

    public static Product getByID(String ID) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        Product[] products = (Product[])Product.getByID((String)ID, (ResourcePath)Product.ResourcePath());
        return products[0];
    }

    public static Product[] getAll() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return (Product[])Product.getAll((ResourcePath)Product.ResourcePath());
    }

    @Override
    protected ResourcePath getResourcePath() {
        return resourcePath;
    }

    protected static ResourcePath ResourcePath() {
        return resourcePath;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DurationPeriod {
        minutes,
        days,
        months,
        years;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ProductPeriod {
        minutes,
        days,
        months,
        years;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ProductType implements StringEnum
    {
        nonrecurring("non-recurring"),
        recurring("recurring");

        private final String name;

        private ProductType(String s) {
            this.name = s;
        }

        @Override
        public boolean equalsName(String otherName) {
            return otherName != null && this.name.equals(otherName);
        }

        public String toString() {
            return this.name;
        }
    }
}

