/*
 * Decompiled with CFR 0.152.
 */
package net.billforward.model;

import net.billforward.BillForwardClient;
import net.billforward.exception.APIConnectionException;
import net.billforward.exception.APIException;
import net.billforward.exception.AuthenticationException;
import net.billforward.exception.CardException;
import net.billforward.exception.InvalidRequestException;
import net.billforward.model.APIResponse;
import net.billforward.model.BillingEntity;
import net.billforward.model.ResourcePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InsertableEntity<TEntityType extends BillingEntity>
extends BillingEntity {
    public InsertableEntity() {
    }

    public InsertableEntity(BillForwardClient client_) {
        super(client_);
    }

    protected static <TStaticEntityType extends BillingEntity> TStaticEntityType[] create(TStaticEntityType entity, ResourcePath path) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return InsertableEntity.create(entity, (ResourcePath)path, null);
    }

    protected static <TStaticEntityType extends BillingEntity> TStaticEntityType[] create(TStaticEntityType entity, ResourcePath path, String extraPath) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        APIResponse<TStaticEntityType> resp;
        BillForwardClient client = BillForwardClient.getClient();
        String fullRoute = path.getPath();
        if (extraPath != null) {
            String apiRoute = path.getPath();
            String endPoint = String.format("/%s", extraPath);
            fullRoute = String.format("%s%s", apiRoute, endPoint);
        }
        if ((resp = client.request(BillForwardClient.RequestMethod.POST, fullRoute, entity, path.getResponseType())) == null || resp.results == null || ((BillingEntity[])resp.results).length < 1) {
            return null;
        }
        return (BillingEntity[])resp.results;
    }

    protected static <TStaticEntityType extends BillingEntity> TStaticEntityType retire(String ID, ResourcePath path) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        String endPoint;
        String apiRoute;
        String fullRoute;
        BillForwardClient client = BillForwardClient.getClient();
        APIResponse<Object> resp = client.request(BillForwardClient.RequestMethod.DELETE, fullRoute = String.format("%s%s", apiRoute = path.getPath(), endPoint = String.format("/%s", ID)), null, path.getResponseType());
        if (resp == null || resp.results == null || ((BillingEntity[])resp.results).length < 1) {
            return null;
        }
        BillingEntity res = ((BillingEntity[])resp.results)[0];
        res.setClient(client);
        return (TStaticEntityType)res;
    }
}

