/*
 * Decompiled with CFR 0.152.
 */
package net.billforward.model;

import net.billforward.BillForwardClient;
import net.billforward.exception.APIConnectionException;
import net.billforward.exception.APIException;
import net.billforward.exception.AuthenticationException;
import net.billforward.exception.CardException;
import net.billforward.exception.InvalidRequestException;
import net.billforward.model.APIResponse;
import net.billforward.model.BillingEntity;
import net.billforward.model.ResourcePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Controller<TEntityType extends BillingEntity> {
    protected BillForwardClient m_client;

    public Controller(BillForwardClient client_) {
        this.m_client = client_;
    }

    public TEntityType getByID(String ID) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        String endPoint;
        ResourcePath path = this.getEntityResourcePath();
        String apiRoute = path.getPath();
        String fullRoute = String.format("%s%s", apiRoute, endPoint = String.format("/%s", ID));
        APIResponse<Object> resp = this.m_client.request(BillForwardClient.RequestMethod.GET, fullRoute, null, path.getResponseType());
        if (resp == null || resp.results == null || ((BillingEntity[])resp.results).length < 1) {
            return null;
        }
        BillingEntity res = ((BillingEntity[])resp.results)[0];
        res.setClient(this.m_client);
        return (TEntityType)res;
    }

    public TEntityType[] getAll() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        BillingEntity[] res;
        ResourcePath path = this.getEntityResourcePath();
        String apiRoute = path.getPath();
        String fullRoute = String.format("%s", apiRoute);
        APIResponse<Object> resp = this.m_client.request(BillForwardClient.RequestMethod.GET, fullRoute, null, path.getResponseType());
        if (resp == null || resp.results == null || ((BillingEntity[])resp.results).length < 1) {
            return null;
        }
        BillingEntity[] billingEntityArray = res = (BillingEntity[])resp.results;
        int n = res.length;
        int n2 = 0;
        while (n2 < n) {
            BillingEntity ntt = billingEntityArray[n2];
            ntt.setClient(this.m_client);
            ++n2;
        }
        return res;
    }

    public abstract ResourcePath getEntityResourcePath();
}

