/*
 * Decompiled with CFR 0.152.
 */
package net.azae.xray;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.azae.xray.XrayInfo;
import net.azae.xray.XrayTest;

public class XrayTestSuite {
    private Map<String, XrayTest> tests = new HashMap<String, XrayTest>();
    private XrayInfo info = new XrayInfo();

    public static XrayTestSuite withInfos(String summary, List<String> envs) {
        XrayTestSuite suite = new XrayTestSuite();
        XrayInfo info = new XrayInfo();
        info.setTestEnvironments(envs);
        info.setSummary(summary);
        suite.setInfo(info);
        return suite;
    }

    public List<XrayTest> getTests() {
        return new ArrayList<XrayTest>(this.tests.values());
    }

    public void setTests(List<XrayTest> tests) {
        tests.forEach(test -> this.tests.put(test.getId(), (XrayTest)test));
    }

    public XrayInfo getInfo() {
        return this.info;
    }

    public void setInfo(XrayInfo info) {
        this.info = info;
    }

    public void putTest(XrayTest test) {
        this.tests.put(test.getId(), test);
    }

    public XrayTest getTestFromId(String uniqueId) {
        if (this.tests.containsKey(uniqueId)) {
            return this.tests.get(uniqueId);
        }
        XrayTest test = new XrayTest();
        test.setId(uniqueId);
        return test;
    }

    public Optional<XrayTestSuite> cloneToUpload() {
        List<XrayTest> uploadTests = this.tests.values().stream().filter(XrayTest::isUpload).collect(Collectors.toList());
        if (uploadTests.size() > 0) {
            XrayTestSuite testSuite = new XrayTestSuite();
            testSuite.setTests(uploadTests);
            testSuite.setInfo(this.info);
            return Optional.of(testSuite);
        }
        return Optional.empty();
    }
}

